<?php

namespace App\Commands;

use CodeIgniter\CLI\CLI;
use CodeIgniter\CLI\BaseCommand;
use App\Libraries\NotificationEmailService;

class NotificationsQueue extends BaseCommand
{
    protected $group       = 'Notifications';
    protected $name        = 'notifications:queue';
    protected $description = 'Fetch initiatives & KPIs due in 29/15/0 days and insert into notificationemails';
    protected $usage       = 'notifications:queue [--today YYYY-MM-DD] [--stages "29,15,0"]';

    protected $options = [
        '--today'  => 'Override today (Y-m-d).',
        '--stages' => 'Comma-separated stages, e.g. "29,15,0".',
    ];

    public function run(array $params)
    {
        $todayOpt = CLI::getOption('today');
        $stagesOpt = CLI::getOption('stages');

        $stages = $stagesOpt ? array_map('intval', explode(',', $stagesOpt)) : [29,15,0];

        $svc = new NotificationEmailService();

        try {
            $result = $svc->queueDue($todayOpt, $stages);
            // $result is an array ['queued' => int, 'skipped' => int]
            $queued = $result['queued'] ?? 0;
            $skipped = $result['skipped'] ?? 0;

            CLI::write("Queued: {$queued} notifications; Skipped (duplicates/invalid): {$skipped}", 'green');
        } catch (\Throwable $e) {
            CLI::error('Failed to queue notifications: ' . $e->getMessage());
            log_message('error', 'notifications:queue exception - {msg}', ['msg' => $e->getMessage()]);
        }
    }
}
