<?php

use Dom\Comment;
use App\Controllers\Home;
use App\Controllers\APIController;
use App\Controllers\KPIsController;
use App\Controllers\UserController;
use App\Controllers\ChatsController;
use App\Controllers\EmailController;
use App\Controllers\GoalsController;
use App\Controllers\ThemesController;
use App\Controllers\CalendarController;
use App\Controllers\CommentsController;
use App\Controllers\ContactsController;
use App\Controllers\SubscriptionController;
use CodeIgniter\Router\RouteCollection;
use App\Controllers\InitiativesController;
use App\Controllers\SubmissionsController;
use App\Controllers\OrganizationsController;
use App\Controllers\CustomizationsController;
use App\Controllers\BSCPerspectivesController;
use App\Controllers\OrganizationStructuresController;

/**
 * @var RouteCollection $routes
 */
$routes->get('/', [Home::class, 'index']);
$routes->get('contact', [ContactsController::class, 'create']);
$routes->post('contact', [ContactsController::class, 'store']);
$routes->get('privacy-policy', 'Home::privacyPolicy');
// $routes->get('add/superadmin', 'UserController::add_admin_form');
// $routes->post('add/superadmin', 'UserController::add_admin');

// group protected routes for non authenticated users only
$routes->group('/', ['filter' => 'noauth'], function ($routes) {
    $routes->get('login', 'UserController::login_form');
    $routes->post('login', [UserController::class, 'login']);
    $routes->get('reset-password', 'UserController::reset_password_form');
    $routes->post('reset-password', 'UserController::reset_password');
    $routes->get('reset-password/message', 'UserController::reset_password_message');
    $routes->get('reset-password/confirm/(:any)', 'UserController::reset_password_confirm_form/$1');
    $routes->post('reset-password/confirm/(:any)', 'UserController::reset_password_confirm/$1');
});

// group protected routes for authenticated users only
$routes->group('/', ['filter' => 'auth'], function ($routes) {
    $routes->get('home', [UserController::class, 'dashboard']);
    $routes->post('logout', 'UserController::logout');
    $routes->get('organization/update/(:any)', [CustomizationsController::class, 'edit']);
    $routes->put('organization/update/(:any)', [CustomizationsController::class, 'update']);

    // change password routes
    $routes->get('user/change-password', [UserController::class, 'change_password_form']);
    $routes->put('user/change-password', [UserController::class, 'change_password']);
    // organizations dashboard
    $routes->get('organization/(:any)', [CustomizationsController::class, 'home']);
    // strategy map route
    $routes->get('strategy-map', [UserController::class, 'strategyMap']);

    // dashboards routes
    $routes->get('themes/view/(:segment)', [ThemesController::class, 'view']);

    // user initiative routes
    // $routes->get('user/initiatives', [InitiativesController::class, 'initiativesOwner']);
    $routes->get('user/(:any)/my-initiatives', [InitiativesController::class, 'user_initiatives']);
    $routes->get('my-initiatives/(:any)/submissions', [SubmissionsController::class, 'initiativesSubmissionIndex']);
    $routes->get('my-initiatives/(:any)/submissions/create', [SubmissionsController::class, 'createInitiativeSubmission']);
    $routes->post('my-initiatives/(:any)/submissions/create', [SubmissionsController::class, 'storeInitiativeSubmission']);

    // initiative comments routes
    $routes->get('my-initiatives/(:any)/comments', [CommentsController::class, 'initiativeCommentsIndex']);
    $routes->post('my-initiatives/(:any)/comments', [CommentsController::class, 'storeInitiativeComment']);

    // user kpi routes
    $routes->get('user/(:any)/my-kpis', [KPIsController::class, 'user_kpis']);
    $routes->get('my-kpis/(:any)/submissions', [SubmissionsController::class, 'kpisSubmissionIndex']);
    $routes->get('my-kpis/(:any)/submissions/create', [SubmissionsController::class, 'createKPISubmission']);
    $routes->post('my-kpis/(:any)/submissions/create', [SubmissionsController::class, 'storeKPISubmission']);

    $routes->get('themes', [ThemesController::class, 'index']);
    $routes->get('goals', [GoalsController::class, 'index']);
    $routes->get('users', [UserController::class, 'index']);

    // kpi comments routes
    $routes->get('my-kpis/(:any)/comments', [CommentsController::class, 'kpiCommentsIndex']);
    $routes->post('my-kpis/(:any)/comments', [CommentsController::class, 'storeKPIComment']);

    // chats routes for auth users
    $routes->get('chats', [ChatsController::class, 'index']);
    $routes->post('chats/create', [ChatsController::class, 'store']);
    $routes->get('chats/view', [ChatsController::class, 'view']);
    $routes->post('chats/reply', [ChatsController::class, 'storeChatReply']);
    $routes->post('message/reply/create', [ChatsController::class, 'storeMessageReply']);

    // calendar routes
    $routes->get('google-calendar/render', [CalendarController::class, 'googleRender']);
    $routes->get('google-calendar/callback', [CalendarController::class, 'googleCallback']);
    $routes->get('google-calendar/consent', [CalendarController::class, 'googleConsent']);

    // protect superadmin routes
    $routes->group('/', ['filter' => 'superadmin'], function ($routes) {
        // super admin dashboard
        $routes->get('admin/dashboard', [UserController::class, 'superadmin_dashboard']);

        // superadmin routes to create and update organizations
        $routes->get('organizations', [OrganizationsController::class, 'index']);
        $routes->get('organizations/create', [OrganizationsController::class, 'create']);
        $routes->post('organizations/create', [OrganizationsController::class, 'new']);
        $routes->post('organizations/disable/(:any)', [OrganizationsController::class, 'disable']);
        $routes->post('organizations/enable/(:any)', [OrganizationsController::class, 'enable']);
        $routes->get('organizations/update/(:any)', [OrganizationsController::class, 'edit']);
        $routes->put('organizations/update/(:any)', [OrganizationsController::class, 'update']);

        $routes->get('settings', [CustomizationsController::class, 'strackerSettings']);
        $routes->post('settings', [CustomizationsController::class, 'storeStrackerSettings']);
        $routes->put('settings/update', [CustomizationsController::class, 'updateStrackerSettings']);

        // super admin to add super admin
        $routes->get('superadmins', [UserController::class, 'get_super_admins']);
        $routes->get('superadmin/new', [UserController::class, 'add_super_admin_form']);
        $routes->post('superadmin/new', [UserController::class, 'add_super_admin']);
        $routes->post('superadmin/disable/(:num)', [UserController::class, 'disable_super_admin']);
        $routes->post('superadmin/enable/(:num)', [UserController::class, 'enable_super_admin']);
        // get contacts route
        $routes->get('contacts', [ContactsController::class, 'index']);

        $routes->get('subscriptions', [SubscriptionController::class, 'index']);
        $routes->get('subscriptions/create', [SubscriptionController::class, 'create']);
        $routes->post('subscriptions/create', [SubscriptionController::class, 'store']);
        $routes->get('subscriptions/update/(:segment)', [SubscriptionController::class, 'edit']);
        $routes->put('subscriptions/update/(:segment)', [SubscriptionController::class, 'update']);
        $routes->post('subscriptions/disable/(:num)', [SubscriptionController::class, 'markExpired']);
        $routes->post('subscriptions/enable/(:num)', [SubscriptionController::class, 'enable']);
    });

    // filter for admin, cso and viewer only routes
    $routes->group('/', ['filter' => 'admincso'], function ($routes) {
        // bsc perspectives routes
        $routes->get('bscperspectives', [BSCPerspectivesController::class, 'index']);
        $routes->get('create/bscperspectives', [BSCPerspectivesController::class, 'create']);
        $routes->post('create/bscperspectives', [BSCPerspectivesController::class, 'store']);
        $routes->get('update/bscperspectives/(:any)', [BSCPerspectivesController::class, 'edit']);
        $routes->put('update/bscperspectives/(:any)', [BSCPerspectivesController::class, 'update']);
        // route to disable and enable bsc perspectives
        $routes->post('bscperspectives/disable/(:num)', [BSCPerspectivesController::class, 'disable']);
        $routes->post('bscperspectives/enable/(:num)', [BSCPerspectivesController::class, 'enable']);

        // routes for themes
        $routes->get('themes/create', [ThemesController::class, 'create']);
        $routes->post('themes/create', [ThemesController::class, 'store']);
        $routes->get('update/themes/(:any)', [ThemesController::class, 'edit']);
        $routes->put('update/themes/(:any)', [ThemesController::class, 'update']);
        // route to disable and enable themes
        $routes->post('themes/disable/(:num)', [ThemesController::class, 'disable']);
        $routes->post('themes/enable/(:num)', [ThemesController::class, 'enable']);
        $routes->post('themes/(:num)/complete', [ThemesController::class, 'markComplete']);

        // routes for goals
        $routes->get('goals/create', [GoalsController::class, 'create']);
        $routes->post('goals/create', [GoalsController::class, 'store']);
        $routes->get('update/goals/(:any)', [GoalsController::class, 'edit']);
        $routes->put('update/goals/(:any)', [GoalsController::class, 'update']);
        // route to disable and enable goals
        $routes->post('goals/disable/(:num)', [GoalsController::class, 'disable']);
        $routes->post('goals/enable/(:num)', [GoalsController::class, 'enable']);
        $routes->post('goals/(:num)/complete', [GoalsController::class, 'markComplete']);

        // redirect from goals page to create initiative page
        $routes->get('initiatives', [InitiativesController::class, 'index']);
        $routes->get('goal/(:any)/initiatives', [InitiativesController::class, 'goalInitiatives']);
        $routes->get('goal/(:any)/initiatives/create', [InitiativesController::class, 'create']);
        $routes->post('initiatives/create', [InitiativesController::class, 'store']);
        $routes->get('initiatives/update/(:any)', [InitiativesController::class, 'edit']);
        $routes->put('initiatives/update/(:any)', [InitiativesController::class, 'update']);
        // route to disable and enable initiatives
        $routes->post('initiative/(:num)/disable', [InitiativesController::class, 'disable']);
        $routes->post('initiative/(:num)/enable', [InitiativesController::class, 'enable']);
        $routes->post('initiative/(:num)/complete', [InitiativesController::class, 'markComplete']);
        // assign intiative owner
        $routes->get('initiatives/(:segment)/owners', [InitiativesController::class, 'initiative_owners']);
        $routes->get('initiatives/(:segment)/owner/assign', [InitiativesController::class, 'initiative_owner_form']);
        $routes->post('initiatives/(:segment)/owner/assign', [InitiativesController::class, 'assign_initiative_owner']);
        // $routes->post('goals/initiative/owner/(:num)/remove', [InitiativesController::class, 'remove_initiative_owner']);
        $routes->post('initiatives/(:num)/owner/disable', [InitiativesController::class, 'disable_initiative_owner']);
        $routes->post('initiatives/(:num)/owner/enable', [InitiativesController::class, 'enable_initiative_owner']);

        // kpi routes
        $routes->get('initiatives/(:segment)/kpis', [KPIsController::class, 'index']);
        $routes->get('initiatives/(:segment)/kpi/create', [KPIsController::class, 'create']);
        $routes->post('initiatives/(:segment)/kpi/create', [KPIsController::class, 'store']);
        $routes->get('initiatives/kpi/update/(:segment)', [KPIsController::class, 'edit']);
        $routes->post('initiatives/kpi/update/(:segment)', [KPIsController::class, 'update']);

        // route to disable and enable kpis
        $routes->post('kpi/disable/(:num)', [KPIsController::class, 'disable']);
        $routes->post('kpi/enable/(:num)', [KPIsController::class, 'enable']);
        $routes->post('kpi/(:num)/complete', [KPIsController::class, 'markComplete']);
        $routes->get('kpis', [KPIsController::class, 'all_kpis']);
        $routes->post('kpis/create/bulk', [KPIsController::class, 'storeBulk']);

        // kpi owners routes
        $routes->get('initiatives/kpi/(:any)/owners', [KPIsController::class, 'kpi_owners']);
        $routes->get('initiatives/kpi/(:any)/owner/assign', [KPIsController::class, 'kpi_owner_form']);
        $routes->post('initiatives/kpi/(:any)/owner/assign', [KPIsController::class, 'assign_kpi_owner']);
        $routes->post('kpi/(:num)/owner/disable', [KPIsController::class, 'disable_kpi_owner']);
        $routes->post('kpi/(:num)/owner/enable', [KPIsController::class, 'enable_kpi_owner']);

        // routes to get reports for CSO
        $routes->get('reports', [SubmissionsController::class, 'reports']);
        $routes->get('reports/(:any)', [SubmissionsController::class, 'viewReport']);
        $routes->post('reports/(:any)', [SubmissionsController::class, 'reportAction']);

        // chat routes for cso
        $routes->post('chats/disable/(:any)', [ChatsController::class, 'disable']);
        $routes->post('chats/enable/(:any)', [ChatsController::class, 'enable']);

        // routes for cso to send emails
        $routes->get('emails', [EmailController::class, 'index']);
        $routes->get('emails/create', [EmailController::class, 'create']);
        $routes->post('emails/create', [EmailController::class, 'store']);
        $routes->get('emails/view', [EmailController::class, 'view']);
    });

    // limit grouped routes to only admin and viewer
    $routes->group('/', ['filter' => 'adminviewer'], function ($routes) {

        // organization structure routes
        $routes->get('structures', [OrganizationStructuresController::class, 'index']);
        $routes->get('create/structures', [OrganizationStructuresController::class, 'create']);
        $routes->post('create/structures', [OrganizationStructuresController::class, 'store']);
        $routes->get('update/structure/(:any)', [OrganizationStructuresController::class, 'edit']);
        $routes->put('update/structure/(:any)', [OrganizationStructuresController::class, 'update']);
        // route to disable and enable organization structure item
        $routes->post('structure/disable/(:num)', [OrganizationStructuresController::class, 'disable']);
        $routes->post('structure/enable/(:num)', [OrganizationStructuresController::class, 'enable']);

        // routes for users handling by admin
        $routes->get('users/create', [UserController::class, 'add_user_form']);
        $routes->post('users/create', [UserController::class, 'add_user']);
        $routes->get('update/users/(:any)', [UserController::class, 'edit_user_form']);
        $routes->put('update/users/(:any)', [UserController::class, 'update_user']);
        // route to disable and enable organization structure item
        $routes->post('users/disable/(:num)', [UserController::class, 'disable']);
        $routes->post('users/enable/(:num)', [UserController::class, 'enable']);
    });
});


$routes->get('api/themes/(:segment)', [APIController::class, 'exportThemes']);
$routes->get('api/goals/(:segment)', [APIController::class, 'exportGoals']);
$routes->get('api/initiatives/(:segment)', [APIController::class, 'exportInitiatives']);
$routes->get('api/kpis/(:segment)', [APIController::class, 'exportKPIs']);

