<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\BSCPerspectivesModel;
use App\Models\OrganizationsModel;
use CodeIgniter\HTTP\ResponseInterface;

class BSCPerspectivesController extends BaseController
{
    protected $bscPerspectivesModel;
    protected $organizationsModel;
    protected $organization;

    public function __construct()
    {
        $this->bscPerspectivesModel = new BSCPerspectivesModel();
        $this->organizationsModel = new OrganizationsModel();
        $this->organization = $this->organizationsModel->where('slug', session()->get('slug'))->first();
    }
    public function index()
    {
        $bscperspectives = $this->bscPerspectivesModel->where('organizations_id', $this->organization['id'])->findAll();

        return view('bscperspectives/index', ['organization' => $this->organization, 'bscperspectives' => $bscperspectives]);
    }

    // display form for creating Strategy Framework Perspectives
    public function create()
    {

        return view('bscperspectives/create', ['organization' => $this->organization]);
    }

    // retreive and store perspectives in db
    public function store()
    {

        $rules = [
            'name' => 'required|string|max_length[255]'
        ];

        if (!$this->validate($rules)) {
            return view('bscperspectives/create', ['validation' => $this->validator, 'organization' => $this->organization]);
        }

        $data = [
            'organizations_id' => $this->organization['id'],
            'slug' => substr(md5(uniqid(time(), true)), 0, 40),
            'name' => $this->request->getPost('name'),
        ];

        if ($this->bscPerspectivesModel->save($data)) {
            return redirect()->to('bscperspectives')->with('success', 'Strategy Framework Perspective saved successfully.');
        }
    }

    // display form for updating Strategy Framework Perspective
    public function edit($slug)
    {
        $bscperspective = $this->bscPerspectivesModel->where('slug', $slug)->first();

        return view('bscperspectives/edit', ['organization' => $this->organization, 'bscperspective' => $bscperspective]);
    }
    public function update()
    {
        $id = $this->request->getPost('id');
        $bscperspective = $this->bscPerspectivesModel->find($id);

        $rules = [
            'name' => 'required|string|max_length[255]'
        ];

        if (!$this->validate($rules)) {
            return view('bscperspectives/edit', ['validation' => $this->validator, 'organization' => $this->organization, 'bscperspective' => $bscperspective]);
        }

        $data = [
            'name' => $this->request->getPost('name'),
        ];

        if ($this->bscPerspectivesModel->update($id, $data)) {
            return redirect()->to('bscperspectives')->with('success', 'Strategy Framework Perspective updated successfully');
        }
    }

    // disable Strategy Framework Perspective
    public function disable($id)
    {
        $data = [
            'status' => 'inactive',
        ];

        if($this->bscPerspectivesModel->update($id, $data))
        {
            return redirect()->to('bscperspectives')->with('success', 'Strategy Framework Perspective disabled successfully');
        }
    }

        // disable Strategy Framework Perspective
        public function enable($id)
        {
            $data = [
                'status' => 'active',
            ];
    
            if($this->bscPerspectivesModel->update($id, $data))
            {
                return redirect()->to('bscperspectives')->with('success', 'Strategy Framework Perspective enabled successfully');
            }
        }
}
