<?php

namespace App\Controllers;

use App\Models\UserModel;
use App\Models\InitiativesModel;
use App\Models\OrganizationsModel;
use App\Controllers\BaseController;
use App\Models\CommentsModel;
use App\Models\KPIModel;
use CodeIgniter\HTTP\ResponseInterface;

class CommentsController extends BaseController
{
    protected $organizationsModel;
    protected $organization;
    protected $initiativesModel;
    protected $usersModel;
    protected $commentsModel;
    protected $kpisModel;

    public function __construct()
    {
        $this->organizationsModel = new OrganizationsModel();
        $this->initiativesModel = new InitiativesModel();
        $this->usersModel = new UserModel();
        $this->commentsModel = new CommentsModel();
        $this->kpisModel = new KPIModel();
        $this->organization = $this->organizationsModel->where('slug', session()->get('slug'))->first();
    }

    // get comments for initiatives or kpi
    public function getComments($project, $projectType, $typeId)
    {
        $comments = $this->commentsModel->orderBy('created_at', 'DESC')->where('project_type', $project)->where($projectType, $typeId)->findAll();

        // add user's name to comments
        foreach ($comments as &$comment) {
            $user = $this->usersModel->where('id', $comment['user_id'])->first();
            $comment['user'] = $user['name'];
        }

        return $comments;
    }
    // get comments for an intiative
    public function initiativeCommentsIndex($slug)
    {
        $initiative = $this->initiativesModel->where('slug', $slug)->first();
        $comments = $this->getComments('initiative', 'initiative_id', $initiative['id']);
        // dd($comments);

        return view('comments/initiatives/index', ['organization' => $this->organization, 'initiative' => $initiative, 'comments' => $comments]);
    }

    // store initiative comments in the db
    public function storeInitiativeComment()
    {
        $initiativeId = $this->request->getPost('id');
        $initiative = $this->initiativesModel->where('id', $initiativeId)->first();
        $comments = $this->getComments('initiative', 'initiative_id', $initiative['id']);

        $rules = [
            'comment' => 'required|max_length[300]',
        ];

        if (!$this->validate($rules)) {
            return view('comments/initiatives/index', ['validation' => $this->validator, 'organization' => $this->organization, 'initiative' => $initiative, 'comments' => $comments]);
        }

        $data = [
            'slug' => substr(md5(uniqid(time(), true)), 0, 40),
            'organization_id' => $this->organization['id'],
            'project_type' => 'initiative',
            'initiative_id' => $initiativeId,
            'user_id' => session()->get('user_id'),
            'comment_body' => $this->request->getPost('comment'),
        ];

        if ($this->commentsModel->save($data)) {
            return redirect()->to('my-initiatives/' . $initiative['slug'] . '/comments')->with('success', 'Comment saved successfully');
        }
    }

    // display kpi comments and form for creating new ones
    public function kpiCommentsIndex($slug)
    {
        $kpi = $this->kpisModel->where('slug', $slug)->first();
        // dd($slug);
        $comments = $this->getComments('kpi', 'kpi_id', $kpi['id']);

        // add user's name to comments
        foreach ($comments as &$comment) {
            $user = $this->usersModel->where('id', $comment['user_id'])->first();
            $comment['user'] = $user['name'];
        }

        return view('comments/kpis/index', ['organization' => $this->organization, 'kpi' => $kpi, 'comments' => $comments]);
    }

    // store kpi comments in the db
    public function storeKPIComment()
    {
        $kpiId = $this->request->getPost('id');
        $kpi = $this->kpisModel->where('id', $kpiId)->first();
        $comments = $this->getComments('kpi', 'kpi_id', $kpi['id']);

        $rules = [
            'comment' => 'required|max_length[300]',
        ];

        if (!$this->validate($rules)) {
            return view('comments/kpis/index', ['validation' => $this->validator, 'organization' => $this->organization, 'kpi' => $kpi, 'comments' => $comments]);
        }

        $data = [
            'slug' => substr(md5(uniqid(time(), true)), 0, 40),
            'organization_id' => $this->organization['id'],
            'project_type' => 'kpi',
            'kpi_id' => $kpiId,
            'user_id' => session()->get('user_id'),
            'comment_body' => $this->request->getPost('comment'),
        ];

        if ($this->commentsModel->save($data)) {
            return redirect()->to('my-kpis/' . $kpi['slug'] . '/comments')->with('success', 'Comment saved successfully');
        }
    }
}
