<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\ContactsModel;
use CodeIgniter\HTTP\ResponseInterface;

class ContactsController extends BaseController
{
    protected $contactModel;
    protected $email;
    
    public function __construct()
    {
        $this->contactModel = new ContactsModel();
        $this->email = \Config\Services::email();
    }
    
    public function sendMail($recipient, $subject, $message)
    {

        $this->email->setTo($recipient);
        $this->email->setSubject($subject);
        $this->email->setMessage($message);

        if ($this->email->send()) {
            return true;
        } else {
            // This shows the error message and exits
            echo $this->email->printDebugger(['headers', 'subject', 'body']);
            exit;
        }
    }
    
    public function index()
    {
        $contacts = $this->contactModel->orderBy('created_at', 'DESC')->findAll();

        return view('users/superadmin/contacts', ['contacts' => $contacts]);
    }
    
    // display contact form
    public function create()
    {
        return view('contact');
    }

    // collect contact information form and send to db
    public function store()
    {
        $rules = [
            'name' => [
                'rules'  => 'required|max_length[255]',
                'errors' => [
                    'required'   => 'Name is required.',
                    'max_length' => 'Name cannot exceed 255 characters.',
                ],
            ],
            'email' => [
                'rules'  => 'required|valid_email|max_length[255]',
                'errors' => [
                    'required'    => 'Email is required.',
                    'valid_email' => 'Please provide a valid email address.',
                    'max_length'  => 'Email cannot exceed 255 characters.',
                ],
            ],
            'subject' => [
                'rules'  => 'required|max_length[255]',
                'errors' => [
                    'required'   => 'Subject is required.',
                    'max_length' => 'Subject cannot exceed 255 characters.',
                ],
            ],
            'name_of_org' => [
                'rules'  => 'required|max_length[255]',
                'errors' => [
                    'required'   => 'Organization name is required.',
                    'max_length' => 'Organization name cannot exceed 255 characters.',
                ],
            ],
            'whatsapp_no' => [
                'rules'  => 'required|max_length[255]',
                'errors' => [
                    'required'   => 'WhatsApp number is required.',
                    'max_length' => 'WhatsApp number cannot exceed 255 characters.',
                ],
            ],
            'role_in_org' => [
                'rules'  => 'required|max_length[255]',
                'errors' => [
                    'required'   => 'Role in organization is required.',
                    'max_length' => 'Role in organization cannot exceed 255 characters.',
                ],
            ],
            'message' => [
                'rules'  => 'required|max_length[2000]',
                'errors' => [
                    'required'   => 'Message is required.',
                    'max_length' => 'Message cannot exceed 2000 characters.',
                ],
            ],
        ];

        if (!$this->validate($rules)) {

            return view('contact', ['validation' => $this->validator]);
        }



        $data = [
            'name'         => $this->request->getPost('name'),
            'email'         => $this->request->getPost('email'),
            'subject'         => $this->request->getPost('subject'),
            'message'        => $this->request->getPost('message'),
            'application'     => 'L & D Planner',
            'name_of_org'        => $this->request->getPost('name_of_org'),
            'role_in_org'        => $this->request->getPost('role_in_org'),
            'whatsapp_no'        => $this->request->getPost('whatsapp_no'),
        ];

        $subject = "New Lead Submission for S-Tracker";

        $message = "
            <div style='font-family: Arial, sans-serif; color:#333; line-height:1.6; max-width:600px; margin:auto;'>
                <h2 style='text-align:center; background:#2e86de; color:white; padding:15px; border-radius:8px 8px 0 0;'>
                    New S-Tracker Lead Notification
                </h2>
                <p>Hello Gbitse,</p>
                <p>You have received a new lead for <strong>S-Tracker</strong> with the following details:</p>

                <table style='width:100%; border-collapse:collapse; margin-top:15px;'>
                    <tr>
                        <td style='padding:8px; border:1px solid #ccc; font-weight:bold;'>Name</td>
                        <td style='padding:8px; border:1px solid #ccc;'>{$data['name']}</td>
                    </tr>
                    <tr>
                        <td style='padding:8px; border:1px solid #ccc; font-weight:bold;'>Email</td>
                        <td style='padding:8px; border:1px solid #ccc;'>{$data['email']}</td>
                    </tr>
                    <tr>
                        <td style='padding:8px; border:1px solid #ccc; font-weight:bold;'>Organization</td>
                        <td style='padding:8px; border:1px solid #ccc;'>{$data['name_of_org']}</td>
                    </tr>
                    <tr>
                        <td style='padding:8px; border:1px solid #ccc; font-weight:bold;'>Role</td>
                        <td style='padding:8px; border:1px solid #ccc;'>{$data['role_in_org']}</td>
                    </tr>
                    <tr>
                        <td style='padding:8px; border:1px solid #ccc; font-weight:bold;'>WhatsApp</td>
                        <td style='padding:8px; border:1px solid #ccc;'>{$data['whatsapp_no']}</td>
                    </tr>
                    <tr>
                        <td style='padding:8px; border:1px solid #ccc; font-weight:bold;'>Message</td>
                        <td style='padding:8px; border:1px solid #ccc;'>{$data['message']}</td>
                    </tr>
                </table>

                <p style='text-align:center; margin-top:25px;'>
                    <a href='mailto:{$data['email']}' 
                    style='background:#27ae60; color:white; padding:12px 20px; 
                            border-radius:6px; text-decoration:none; font-weight:bold;'>
                        Reply to Lead
                    </a>
                </p>

                <div style='margin-top:30px; text-align:center; font-size:12px; color:#888;'>
                    Suite 3F4, Katu Koma Plaza, 52 Off Oladipo Diya Way, Sector Centre C, Abuja, Nigeria.<br>
                    &copy; " . date('Y') . " Learning Impact. All Rights Reserved.
                </div>
            </div>
            ";

        if ($this->contactModel->insert($data)) {
            $this->sendMail('gbitse@gmail.com', $subject, $message);
            
            return redirect()->to('contact?status=success');
        }

    }
}
