<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\CustomizationModel;
use App\Models\OrganizationsModel;
use App\Models\OrganizationStructureModel;
use CodeIgniter\HTTP\ResponseInterface;

class OrganizationStructuresController extends BaseController
{
    protected $organizationStructureModel;
    protected $customizationModel;
    protected $items;
    protected $customization;
    protected $organizationsModel;
    protected $organization;
    public function __construct()
    {
        $this->organizationStructureModel = new OrganizationStructureModel();
        $this->customizationModel = new CustomizationModel();
        $this->items = $this->organizationStructureModel->get()->getResultArray();
        $this->customization = $this->customizationModel->first();
        $this->organizationsModel = new OrganizationsModel();
        $this->organization = $this->organizationsModel->where('slug', session()->get('slug'))->first();
    }

    public function index()
    {
        $structures = $this->organizationStructureModel->where('organization_id', $this->organization['id'])->orderBy('status', 'ASC')->orderBy('created_at', 'DESC')->findAll();
        // dd($structures);
        
        return view('organizationstructures/index', ['organization' => $this->organization, 'structures' => $structures]);
    }

    // display form for creating new item on the organizational structure
    public function create()
    {
        
        return view('organizationstructures/create', ['organization' => $this->organization]);
    }

    // process form data and store new item on the organizational structure in db
    public function store()
    {
        $rules = [
            'type' => [
                'rules' => 'required|max_length[255]',
                'errors' => [
                    'required' => 'Choose the type of item',
                    'max_length' => 'The type of item cannot exceed 255 characters',
                ],
            ],
            'name' => [
                'rules' => 'required|max_length[255]',
                'errors' => [
                    'required' => 'The name field is required',
                    'max_length' => 'The name cannot exceed 255 characters',
                ],
            ],
        ];

        if (!$this->validate($rules)) {

            return view('organizationstructures/create', ['validation' => $this->validator, 'organization' => $this->organization]);
        }

        $data = [
            'organization_id' => (int) $this->organization['id'],
            'slug' => substr(md5(uniqid(time(), true)), 0, 40),
            'parent_id' => $this->request->getPost('parent_id') ?: null,
            'type' => $this->request->getPost('type'),
            'name' => $this->request->getPost('name'),
        ];

        // dd($data);

        if ($this->organizationStructureModel->save($data))
        {
            return redirect()->to('structures')->with('success', 'Organizational structure item created successfully');
        }
        return redirect()->to('structures')->with('error', 'Unable to create item');
    }

    // display form to edit organization structure item
    public function edit($slug)
    {
        $structure = $this->organizationStructureModel->where('slug', $slug)->first();
        // dd($organization);

        return view('organizationstructures/edit', ['structure' => $structure, 'organization' => $this->organization]);
    }

    public function update($slug)
    {
        $structure = $this->organizationStructureModel->where('slug', $slug)->first();

        $rules = [
            'type' => [
                'rules' => 'required|max_length[255]',
                'errors' => [
                    'required' => 'Choose the type of item',
                    'max_length' => 'The type of item cannot exceed 255 characters',
                ],
            ],
            'name' => [
                'rules' => 'required|max_length[255]',
                'errors' => [
                    'required' => 'The name field is required.',
                    'max_length' => 'The name cannot exceed 255 characters.',
                ],
            ],
        ];

        if (!$this->validate($rules)) {
            return view('organizationstructures/edit', ['validation' => $this->validator, 'organization' => $this->organization]);
        }

        $data = [
            'type' => $this->request->getPost('type'),
            'name' => $this->request->getPost('name'),
        ];

        if ($this->organizationStructureModel->update($structure['id'], $data)) {
            return redirect()->to('structures')->with('success', 'Organizational structure item updated successfully');
        }
        return redirect()->to('structures')->with('error', 'Unable to update organizational structure item');
    }

    // disable organizational structure item
    public function disable($id)
    {
        // dd('ok');
        $data = [
            'status' => 'inactive',
        ];
        // dd($organization);

        if ($this->organizationStructureModel->update($id, $data)) {
            return redirect()->to('structures')->with('success', 'Organizational structure item disabled successfully');
        }
        return redirect()->to('structures')->with('error', 'Unable to disable organizational structure item');
    }

    public function enable($id)
    {
        // dd('enable');
        $data = [
            'status' => 'active',
        ];

        if ($this->organizationStructureModel->update($id, $data)) {
            return redirect()->to('structures')->with('success', 'Organizational structure item enabled successfully');
        }
        return redirect()->to('structures')->with('error', 'Unable to disable organizational structure item');
    }
}
