<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\CustomizationModel;
use App\Models\InitiativesModel;
use App\Models\KPIModel;
use App\Models\OrganizationsModel;
use App\Models\SubmissionsModel;
use App\Models\UserModel;
use CodeIgniter\HTTP\ResponseInterface;

class SubmissionsController extends BaseController
{
    protected $organizationsModel;
    protected $organization;
    protected $initiativesModel;
    protected $submissionsModel;
    protected $email;
    protected $usersModel;
    protected $kpisModel;
    protected $customizationsModel;

    public function __construct()
    {
        $this->organizationsModel = new OrganizationsModel();
        $this->initiativesModel = new InitiativesModel();
        $this->submissionsModel = new SubmissionsModel();
        $this->email = new \App\Controllers\EmailController;
        $this->usersModel = new UserModel();
        $this->kpisModel = new KPIModel();
        $this->customizationsModel = new CustomizationModel();
        $this->organization = $this->organizationsModel->where('slug', session()->get('slug'))->first();
    }
    public function initiativesSubmissionIndex($slug)
    {
        $initiative = $this->initiativesModel->where('slug', $slug)->first();
        $submissions = $this->submissionsModel->where('initiative_id', $initiative['id'])->orderBy('created_at', 'DESC')->findAll();
        foreach ($submissions as &$submission) {
            $submittedBy = $this->usersModel->where('id', $submission['submitted_by'])->first();
            $approvedBy = $this->usersModel->where('id', $submission['cso_id'])->first();
            $submission['submitted_by'] = $submittedBy['name'] ?? '-'; //name of the user that made the submission
            $submission['cso_name'] = $approvedBy['name'] ?? '-'; //name of the cso that approved or declined the request
        }
        // dd($submissions);

        return view('submissions/initiatives/index', ['organization' => $this->organization, 'initiative' => $initiative, 'submissions' => $submissions]);
    }

    // display form for project lead to submit make submission for initiative
    public function createInitiativeSubmission($slug)
    {
        $initiative = $this->initiativesModel->where('slug', $slug)->first();

        return view('submissions/initiatives/create', ['organization' => $this->organization, 'initiative' => $initiative]);
    }

    public function storeInitiativeSubmission()
    {
        $rules = [
            'comment' => 'required',
            'percentage_of_completion' => 'required',
            'file' => [
                'uploaded[file]',
                'mime_in[file,application/pdf,image/jpeg,image/png]',
                'max_size[file,10240]' // 10MB
            ]
        ];

        $initiative = $this->initiativesModel->find($this->request->getPost('id'));

        // Check if a file is uploaded
        $file = $this->request->getFile('file');
        $filePresent = $file && $file->isValid() && !$file->hasMoved();

        // Make file optional
        if (!$filePresent) {
            unset($rules['file']);
        }

        if (!$this->validate($rules)) {
            return view('submissions/initiatives/create', [
                'validation'   => $this->validator,
                'organization' => $this->organization,
                'initiative'   => $initiative
            ]);
        }

        $fileLink = null;

        if ($filePresent) {
            $uploadPath = FCPATH . 'uploads/submissions/';
            $newName = 'initiative_' . $file->getRandomName();

            // Create the folder if it doesn't exist
            if (!is_dir($uploadPath)) {
                mkdir($uploadPath, 0777, true);
            }

            // Move the file to public/uploads/submissions
            $file->move($uploadPath, $newName);

            $fileLink = 'uploads/submissions/' . $newName;
        }

        $data = [
            'slug' => substr(md5(uniqid(time(), true)), 0, 32),
            'organization_id' => $this->organization['id'],
            'project_type' => 'initiative',
            'initiative_id' => $this->request->getPost('id'),
            'submitted_by' => session()->get('user_id'),
            'submitted_comment' => $this->request->getPost('comment'),
            'document_link'     => $fileLink,
            'percentage_of_completion' => $this->request->getPost('percentage_of_completion'),
        ];

        // email details to CSO
        $cso = $this->usersModel->where('role', 'chief_strategy_officer')->where('organizations_id', $this->organization['id'])->first();
        $user = $this->usersModel->where('id', $data['submitted_by'])->first();
        $submitted_by = $user['name'];
        $initiative_name = $initiative['name'];
        $stracker = $this->customizationsModel->first();

        // Create link
        $link = base_url("login");

        $subject = 'Initiative Record Submission on STracker';
        $message = "<p style='margin-top:8px;'>Hello {$cso['name']},</p>
            <p style='margin-top:8px;'>$submitted_by has submitted supporting documents for $initiative_name initiative on STracker for your review. </p>
            <p style='margin-top:8px;'>Click on the link below to login and review the submission.</p>
            <p style='margin: 18px 0; text-align: center;'>
                <a href=\"$link\" style='background-color:#51585e; text-decoration:none; padding:12px 24px; border-radius:6px; color:white; display:inline-block;'>
                    Login
                </a>
            </p>
            <p style='margin-top:8px;'>If the above button does not work, copy this link and paste in your url address bar $link</p>
            <strong style='margin-top:12px;'>Best Regards.</strong>
            <strong style='display:block;'>Learning Impact Model</strong>
            <div style='margin-top:12px; text-align: center; background-color:rgb(233, 233, 233); font-size:12px; padding:12px'>STracker | {$stracker['lim_address']}</div>
            <h3 style='margin-top:8px; text-align: center;'>&copy; " . date('Y') . " Learning Impact Model</h3>";

        if ($this->submissionsModel->save($data)) {
            $this->email->sendMail($cso['email'], $subject, $message);
            return redirect()->to('my-initiatives/' . $initiative['slug'] . '/submissions')->with('success', 'Submission made successfully');
        }
    }

    // get reports for cso based on status
    public function reports()
    {
        $status = $this->request->getGet('status');
        $type = $this->request->getGet('type');
        $reports = [];

        if ($type === 'initiative') {
            $reports = $this->submissionsModel
                ->where('organization_id', $this->organization['id'])
                ->where('project_type', 'initiative')
                ->where('status', $status)
                ->orderBy('created_at', 'DESC')
                ->get()
                ->getResultArray();

            foreach ($reports as &$report) {
                $initiative = $this->initiativesModel->where('id', $report['initiative_id'])->first();
                $user = $this->usersModel->where('id', $report['submitted_by'])->first();
                $approvedBy = $this->usersModel->where('id', $report['cso_id'])->first();

                $report['initiative'] = $initiative['name'] ?? '-';
                $report['project_lead'] = $user['name'] ?? '-';
                $report['cso'] = $approvedBy['name'] ?? '-';
            }
            // dd($reports);

            $action = $this->request->getGet('action');
            if ($action === 'download') {
                // dd($this->organization);
                return view('downloads/initiative_reports', [
                    'organization' => $this->organization,
                    'reports' => $reports,
                    'status' => $status,
                ]);
            }

            return view('initiatives/reports/index', [
                'organization' => $this->organization,
                'reports' => $reports,
                'status' => $status,
            ]);
        }

        if ($type === 'kpi') {
            $reports = $this->submissionsModel
                ->where('organization_id', $this->organization['id'])
                ->where('project_type', 'kpi')
                ->where('status', $status)
                ->orderBy('created_at', 'DESC')
                ->get()
                ->getResultArray();

            foreach ($reports as &$report) {
                $kpi = $this->kpisModel->where('id', $report['kpi_id'])->first();
                $user = $this->usersModel->where('id', $report['submitted_by'])->first();
                $approvedBy = $this->usersModel->where('id', $report['cso_id'])->first();

                $report['kpi'] = $kpi['name'] ?? '-';
                $report['project_lead'] = $user['name'] ?? '-';
                $report['cso'] = $approvedBy['name'] ?? '-';
            }

            $action = $this->request->getGet('action');
            if ($action === 'download') {
                return view('downloads/kpi_reports', [
                    'organization' => $this->organization,
                    'reports' => $reports,
                    'status' => $status,
                ]);
            }

            return view('kpis/reports/index', [
                'organization' => $this->organization,
                'reports' => $reports,
                'status' => $status,
            ]);
        }
    }

    // get details of a full report for cso
    public function viewReport($slug)
    {
        $report = $this->submissionsModel->where('slug', $slug)->first();
        $type = $this->request->getGet('type');

        if ($type === 'initiative') {
            return view('initiatives/reports/view', ['organization' => $this->organization, 'report' => $report]);
        }

        if ($type === 'kpi') {
            return view('kpis/reports/view', ['organization' => $this->organization, 'report' => $report]);
        }
    }

    // cso to reject, approve or mark initiative completion
    public function reportAction()
    {
        $type = $this->request->getGet('type');
        $rules = [
            'action' => 'required',
            'comment' => 'required|max_length[255]'
        ];

        if ($type === 'initiative') {
            $initiativeId = $this->request->getPost('initiative_id');
            $reportId = $this->request->getPost('report_id');
            $report = $this->submissionsModel->where('id', $reportId)->first();

            if (!$this->validate($rules)) {
                return view('initiatives/reports/view', ['organization' => $this->organization, 'report' => $report, 'validation' => $this->validator]);
            }

            $submissionData = [];
            $action = $this->request->getPost('action');

            // email details to the user who submitted the record
            $cso = $this->usersModel->where('role', 'chief_strategy_officer')->where('organizations_id', $this->organization['id'])->first();
            $user = $this->usersModel->where('id', $report['submitted_by'])->first();
            $initiative = $this->initiativesModel->where('id', $initiativeId)->first();
            $initiative_name = $initiative['name'];
            $cso_name = $cso['name'] ?? $this->organization['name'];

            // Create link
            $link = base_url("login");
            $emailAction = '';
            $stracker = $this->customizationsModel->first();

            if ($action === 'mark_complete' || $action === 'approve') {
                $emailAction = 'approved';
            } elseif ($action === 'reject') {
                $emailAction = 'rejected';
            }

            $subject = 'Initiative Record Update on STracker';
            $message = "<p style='margin-top:8px;'>Hello {$user['name']},</p>
            <p style='margin-top:8px;'>$cso_name has $emailAction the supporting documents you submitted for $initiative_name initiative on STracker. </p>
            <p style='margin-top:8px;'>Click on the link below and login to get the complete details.</p>
            <p style='margin: 18px 0; text-align: center;'>
                <a href=\"$link\" style='background-color:#51585e; text-decoration:none; padding:12px 24px; border-radius:6px; color:white; display:inline-block;'>
                    Login
                </a>
            </p>
            <p style='margin-top:8px;'>If the above button does not work, copy this link and paste in your url address bar $link</p>
            <strong style='margin-top:12px;'>Best Regards.</strong>
            <strong style='display:block;'>Learning Impact Model</strong>
            <div style='margin-top:12px; text-align: center; background-color:rgb(233, 233, 233); font-size:12px; padding:12px'>STracker | {$stracker['lim_address']}</div>
            <h3 style='margin-top:8px; text-align: center;'>&copy; " . date('Y') . " Learning Impact Model</h3>";

            if ($action === 'mark_complete') {
                $submissionData = [
                    'cso_id' => session()->get('user_id'),
                    'cso_comment' => $this->request->getPost('comment'),
                    'status' => 'approved',
                    'approved_at' => date('Y-m-d H:i:s'),
                    'approved_percentage_of_completion' => $this->request->getPost('approved_percentage_of_completion'),
                ];

                $initiativeData = [
                    'status' => 'completed',
                    'rag_status' => 'green',
                    'current_status' => 'complete',
                ];

                // dd($submissionData);

                //update initiative
                $this->initiativesModel->update($initiativeId, $initiativeData);
                //update submission
                if ($this->submissionsModel->update($reportId, $submissionData)) {
                    $this->email->sendMail($user['email'], $subject, $message);
                    return redirect()->to('reports?type=initiative&status=pending')->with('success', 'Report approved');
                }
            }

            if ($action === 'approve') {
                $submissionData = [
                    'cso_comment' => $this->request->getPost('comment'),
                    'status' => 'approved',
                    'approved_at' => date('Y-m-d H:i:s'),
                    'cso_id' => session()->get('user_id'),
                    'approved_percentage_of_completion' => $this->request->getPost('approved_percentage_of_completion'),
                ];

                if ($this->submissionsModel->update($reportId, $submissionData)) {
                    $this->email->sendMail($user['email'], $subject, $message);
                    return redirect()->to('reports?type=initiative&status=pending')->with('success', 'Report approved');
                }
            }

            if ($action === 'reject') {
                $submissionData = [
                    'cso_comment' => $this->request->getPost('comment'),
                    'status' => 'rejected',
                    'approved_at' => date('Y-m-d H:i:s'),
                    'cso_id' => session()->get('user_id'),
                    'approved_percentage_of_completion' => $this->request->getPost('approved_percentage_of_completion'),
                ];

                if ($this->submissionsModel->update($reportId, $submissionData)) {
                    $this->email->sendMail($user['email'], $subject, $message);
                    return redirect()->to('reports?type=initiative&status=pending')->with('success', 'Report rejected');
                }
            }
        }

        if ($type === 'kpi') {
            $kpiId = $this->request->getPost('kpi_id');
            $reportId = $this->request->getPost('report_id');
            $report = $this->submissionsModel->where('id', $reportId)->first();

            if (!$this->validate($rules)) {
                return view('kpis/reports/view', ['organization' => $this->organization, 'report' => $report, 'validation' => $this->validator]);
            }

            $submissionData = [];
            $action = $this->request->getPost('action');

            // email details to the user who submitted the record
            $cso = $this->usersModel->where('role', 'chief_strategy_officer')->where('organizations_id', $this->organization['id'])->first();
            $user = $this->usersModel->where('id', $report['submitted_by'])->first();
            $kpi = $this->kpisModel->where('id', $kpiId)->first();
            $kpi_name = $kpi['name'];
            $cso_name = $cso['name'] ?? $this->organization['name'];

            // Create link
            $link = base_url("login");
            $emailAction = '';
            $stracker = $this->customizationsModel->first();

            if ($action === 'approve') {
                $emailAction = 'approved';
            } elseif ($action === 'reject') {
                $emailAction = 'rejected';
            }

            $subject = 'KPI Record Update on STracker';
            $message = "<p style='margin-top:8px;'>Hello {$user['name']},</p>
            <p style='margin-top:8px;'>$cso_name has $emailAction the supporting documents you submitted for $kpi_name KPI on STracker. </p>
            <p style='margin-top:8px;'>Click on the link below and login to get the complete details.</p>
            <p style='margin: 18px 0; text-align: center;'>
                <a href=\"$link\" style='background-color:#51585e; text-decoration:none; padding:12px 24px; border-radius:6px; color:white; display:inline-block;'>
                    Login
                </a>
            </p>
            <p style='margin-top:8px;'>If the above button does not work, copy this link and paste in your url address bar $link</p>
            <strong style='margin-top:12px;'>Best Regards.</strong>
            <strong style='display:block;'>Learning Impact Model</strong>
            <div style='margin-top:12px; text-align: center; background-color:rgb(233, 233, 233); font-size:12px; padding:12px'>STracker | {$stracker['lim_address']}</div>
            <h3 style='margin-top:8px; text-align: center;'>&copy; " . date('Y') . " Learning Impact Model</h3>";

            if ($action === 'approve') {
                $submissionData = [
                    'cso_comment' => $this->request->getPost('comment'),
                    'status' => 'approved',
                    'approved_at' => date('Y-m-d H:i:s'),
                    'cso_id' => session()->get('user_id'),
                    'approved_percentage_of_completion' => $this->request->getPost('approved_percentage_of_completion'),
                ];
                
                // dd($submissionData);

                if ($this->submissionsModel->update($reportId, $submissionData)) {
                    $this->email->sendMail($user['email'], $subject, $message);
                    return redirect()->to('reports?type=kpi&status=pending')->with('success', 'Report approved');
                }
            }

            if ($action === 'reject') {
                $submissionData = [
                    'cso_comment' => $this->request->getPost('comment'),
                    'status' => 'rejected',
                    'approved_at' => date('Y-m-d H:i:s'),
                    'cso_id' => session()->get('user_id'),
                    'approved_percentage_of_completion' => $this->request->getPost('approved_percentage_of_completion'),
                ];

                if ($this->submissionsModel->update($reportId, $submissionData)) {
                    $this->email->sendMail($user['email'], $subject, $message);
                    return redirect()->to('reports?type=kpi&status=pending')->with('success', 'Report rejected');
                }
            }
        }
    }

    // fetch kpis submissions
    public function kpisSubmissionIndex($slug)
    {
        $kpi = $this->kpisModel->where('slug', $slug)->first();
        $submissions = $this->submissionsModel->where('kpi_id', $kpi['id'])->orderBy('created_at', 'DESC')->findAll();
        foreach ($submissions as &$submission) {
            $submittedBy = $this->usersModel->where('id', $submission['submitted_by'])->first();
            $approvedBy = $this->usersModel->where('id', $submission['cso_id'])->first();
            $submission['submitted_by'] = $submittedBy['name'] ?? '-'; //name of the user that made the submission
            $submission['cso_name'] = $approvedBy['name'] ?? '-'; //name of the cso that approved or declined the request
        }
        // dd($submissions);

        return view('submissions/kpis/index', ['organization' => $this->organization, 'kpi' => $kpi, 'submissions' => $submissions]);
    }

    // dsiplay form to create KPI submission
    public function createKPISubmission($slug)
    {
        $kpi = $this->kpisModel->where('slug', $slug)->first();

        return view('submissions/kpis/create', ['organization' => $this->organization, 'kpi' => $kpi]);
    }

    // collect KPI submission data and store in db
    public function storeKPISubmission()
    {
        $rules = [
            'comment' => 'required',
            'percentage_of_completion' => 'required',
            'file' => [
                'uploaded[file]',
                'mime_in[file,application/pdf,image/jpeg,image/png]',
                'max_size[file,10240]' // 10MB
            ]
        ];

        $kpi = $this->kpisModel->find($this->request->getPost('id'));

        // Check if a file is uploaded
        $file = $this->request->getFile('file');
        $filePresent = $file && $file->isValid() && !$file->hasMoved();

        // Make file optional
        if (!$filePresent) {
            unset($rules['file']);
        }

        if (!$this->validate($rules)) {
            return view('submissions/kpis/create', [
                'validation'   => $this->validator,
                'organization' => $this->organization,
                'kpi'   => $kpi
            ]);
        }

        $fileLink = null;

        if ($filePresent) {
            $uploadPath = FCPATH . 'uploads/submissions/';
            $newName = 'kpi_' . $file->getRandomName();

            // Create the folder if it doesn't exist
            if (!is_dir($uploadPath)) {
                mkdir($uploadPath, 0777, true);
            }

            // Move the file to public/uploads/submissions
            $file->move($uploadPath, $newName);

            $fileLink = 'uploads/submissions/' . $newName;
        }

        $data = [
            'slug' => substr(md5(uniqid(time(), true)), 0, 32),
            'organization_id' => $this->organization['id'],
            'project_type' => 'kpi',
            'kpi_id' => $this->request->getPost('id'),
            'submitted_by' => session()->get('user_id'),
            'submitted_comment' => $this->request->getPost('comment'),
            'document_link'     => $fileLink,
            'percentage_of_completion' => $this->request->getPost('percentage_of_completion'),
        ];

        // email details to CSO
        $cso = $this->usersModel->where('role', 'chief_strategy_officer')->where('organizations_id', $this->organization['id'])->first();
        $user = $this->usersModel->where('id', $data['submitted_by'])->first();
        $submitted_by = $user['name'];
        $kpi_name = $kpi['name'];
        $stracker = $this->customizationsModel->first();

        // Create link
        $link = base_url("login");

        $subject = 'KPI Record Submission on STracker';
        $message = "<p style='margin-top:8px;'>Hello {$cso['name']},</p>
            <p style='margin-top:8px;'>$submitted_by has submitted supporting documents for $kpi_name KPI on STracker for your review. </p>
            <p style='margin-top:8px;'>Click on the link below to login and review the submission.</p>
            <p style='margin: 18px 0; text-align: center;'>
                <a href=\"$link\" style='background-color:#51585e; text-decoration:none; padding:12px 24px; border-radius:6px; color:white; display:inline-block;'>
                    Login
                </a>
            </p>
            <p style='margin-top:8px;'>If the above button does not work, copy this link and paste in your url address bar $link</p>
            <strong style='margin-top:12px;'>Best Regards.</strong>
            <strong style='display:block;'>Learning Impact Model</strong>
            <div style='margin-top:12px; text-align: center; background-color:rgb(233, 233, 233); font-size:12px; padding:12px'>STracker | {$stracker['lim_address']}</div>
            <h3 style='margin-top:8px; text-align: center;'>&copy; " . date('Y') . " Learning Impact Model</h3>";

        if ($this->submissionsModel->save($data)) {
            $this->email->sendMail($cso['email'], $subject, $message);
            return redirect()->to('my-kpis/' . $kpi['slug'] . '/submissions')->with('success', 'Submission made successfully');
        }
    }
}
