<?php

namespace App\Controllers;

use DateTime;
use App\Models\UserModel;
use App\Models\GoalsModel;
use App\Models\ThemesModel;
use App\Models\CustomizationModel;
use App\Models\OrganizationsModel;
use App\Controllers\BaseController;
use App\Controllers\EmailController;
use App\Models\BSCPerspectivesModel;
use App\Models\InitiativesModel;
use App\Models\KPIModel;
use CodeIgniter\HTTP\ResponseInterface;
use App\Models\OrganizationStructureModel;
use App\Models\SubmissionsModel;

class UserController extends BaseController
{
    protected $userModel;
    protected $customizationModel;
    protected $organizationStructureModel;
    protected $goalsModel;
    protected $themesModel;
    protected $bscperspectivesModel;
    protected $email;
    protected $organizationsModel;
    protected $organization;
    protected $initiativesController;
    protected $kpisController;
    protected $submissionsModel;
    protected $initiativesModel;
    protected $kpisModel;

    public function __construct()
    {
        $this->userModel = new UserModel();
        $this->customizationModel = new CustomizationModel();
        $this->organizationStructureModel = new OrganizationStructureModel();
        $this->goalsModel = new GoalsModel();
        $this->themesModel = new ThemesModel();
        $this->bscperspectivesModel = new BSCPerspectivesModel();
        $this->email = new EmailController;
        $this->initiativesController = new InitiativesController;
        $this->kpisController = new KPIsController;
        $this->organizationsModel = new OrganizationsModel();
        $this->submissionsModel = new SubmissionsModel();
        $this->initiativesModel = new InitiativesModel();
        $this->kpisModel = new KPIModel();
        $this->organization = $this->organizationsModel->where('slug', session()->get('slug'))->first();
    }

    // get users for an organization
    public function index()
    {
        $users = $this->getUsersWithDepartments($this->organization['id']);
        // dd($users);

        return view('users/index', ['organization' => $this->organization, 'users' => $users]);
    }
    public function superadmin_dashboard()
    {
        $data = [];

        $organizations = $this->organizationsModel->findAll();
        $totalOrganizations = count($organizations);
        $activeOrganizations = 0;
        $inactiveOrganizations = 0;

        foreach ($organizations as $organization) {
            if ($organization['status'] === 'active') {
                $activeOrganizations++;
            } elseif ($organization['status'] === 'inactive') {
                $inactiveOrganizations++;
            }
        }

        $users = $this->userModel->findAll();
        $totalUsers = count($users);
        $activeUsers = 0;
        $inactiveUsers = 0;

        foreach ($users as $user) {
            if ($user['status'] === 'active') {
                $activeUsers++;
            } elseif ($user['status'] === 'inactive') {
                $inactiveUsers++;
            }
        }

        $data = [
            'totalOrganizations' => $totalOrganizations,
            'activeOrganizations' => $activeOrganizations,
            'inactiveOrganizations' => $inactiveOrganizations,
            'totalUsers' => $totalUsers,
            'activeUsers' => $activeUsers,
            'inactiveUsers' => $inactiveUsers,
        ];

        return view('users/superadmin/superadmin_dashboard', $data);
    }

    // form to add super admin by another super admin 
    public function add_super_admin_form()
    {
        return view('users/superadmin/create');
    }

    // add super admin by another super admin
    public function add_super_admin()
    {
        $validationRules = [
            'name' => 'required|max_length[255]|string',
            'email' => 'required|valid_email|is_unique[users.email]',
        ];

        $validationMessages = [
            'name' => [
                'required' => 'The name field is required',
                'string'   => 'The name must be a valid string',
            ],

            'email' => [
                'required'    => 'The email field is required.',
                'valid_email' => 'Please provide a valid email address.',
                'is_unique'   => 'This email has already been taken.'
            ],
        ];

        if (!$this->validate($validationRules, $validationMessages)) {
            return view('users/superadmin/create', ['validation' => $this->validator]);
        }

        $passcode = substr(str_shuffle(bin2hex(random_bytes(4)) . 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz'), 0, 8);
        $hashedPassword = password_hash($passcode, PASSWORD_DEFAULT);

        $data = [
            'organizations_id' => null,
            'slug' => substr(md5(uniqid(time(), true)), 0, 40),
            'organizationstructures_id' => null,
            'role'     => 'superadmin',
            'name'     => $this->request->getPost('name'),
            'email'    => $this->request->getPost('email'),
            'password' => $hashedPassword,
            'passcode' => $passcode,
        ];
        $stracker = $this->customizationModel->first();

        // Create link
        $link = base_url("login");

        $subject = 'New STracker Account';
        $message = "<p style='margin-top:8px;'>Dear {$data['name']},</p>
            <p style='margin-top:8px;'>Learning Impact Model has created a super admin account for you on STracker with the following details:</p>
            <p style='margin-top:8px;'><strong>Email:</strong> {$data['email']}</p>
            <p style='margin-top:8px;'><strong>Password:</strong> {$data['passcode']}</p>
            <p style='margin-top:8px;'>Click on the link below to login.</p>
            <p style='margin: 18px 0; text-align: center;'>
                <a href=\"$link\" style='background-color:#51585e; text-decoration:none; padding:12px 24px; border-radius:6px; color:white; display:inline-block;'>
                    Login
                </a>
            </p>
            <p style='margin-top:8px;'>If the above button does not work, copy this link and paste in your url address bar $link</p>
            <strong style='margin-top:12px;'>Best Regards.</strong>
            <strong style='display:block;'>Learning Impact Model</strong>
            <div style='margin-top:12px; text-align: center; background-color:rgb(233, 233, 233); font-size:12px; padding:12px'>STracker | {$stracker['lim_address']}</div>
            <h3 style='margin-top:8px; text-align: center;'>&copy; " . date('Y') . " Learning Impact Model</h3>";

        if ($this->userModel->save($data)) {
            $this->email->sendMail($data['email'], $subject, $message);

            return redirect()->to('superadmins')->with('success', 'Super admin added successfully');
        }
    }

    // disable user
    public function disable_super_admin($id)
    {
        // dd('ok');
        $data = [
            'status' => 'inactive',
        ];

        if ($this->userModel->update($id, $data)) {
            return redirect()->to('superadmins')->with('success', 'Super admin disabled successfully');
        }
    }

    // enable user
    public function enable_super_admin($id)
    {
        // dd('enable');
        $data = [
            'status' => 'active',
        ];

        if ($this->userModel->update($id, $data)) {
            return redirect()->to('superadmins')->with('success', 'Super admin enabled successfully');
        }
    }

    // return list of super admins
    public function get_super_admins()
    {
        $superadmins = $this->userModel->where('role', 'superadmin')->orderBy('status')->findAll();

        return view('users/superadmin/index', ['superadmins' => $superadmins]);
    }

    // show form for creating super admin for the first time
    public function add_admin_form()
    {
        return view('add_admin');
    }

    //add admin who sets up the application
    public function add_admin()
    {

        // validate user input
        $rules = [
            'name'     => 'required|string',
            'phone'    => 'integer',
            'email'    => 'required|valid_email|is_unique[users.email]',
            'password' => 'required|min_length[8]',
        ];

        if (!$this->validate($rules)) {
            return view('add_admin', ['validation' => $this->validator]);
        }
        // Get input values
        $data = [
            'slug' => substr(md5(uniqid(time(), true)), 0, 40),
            'name'     => $this->request->getPost('name'),
            'phone'    => $this->request->getPost('phone'),  // Optional
            'email'    => $this->request->getPost('email'),
            'password' => password_hash($this->request->getPost('password'), PASSWORD_DEFAULT),
            'status'   => 'active',
            'role'     => 'superadmin',
            'passcode' => $this->request->getPost('password'),
        ];

        // Attempt to insert into database
        if ($this->userModel->insert($data)) {
            $user = $this->userModel->where('email', $data['email'])->first();

            session()->set([
                'role' => $user['role'],
                'org_id' => $user['organizations_id'],
                'user_id' => $user['id'],
                'name' => $user['name'],
                'is_logged_in' => true,
            ]);

            session()->setFlashdata('success', 'Admin account created successfully');

            return redirect()->to('admin/dashboard');
        }

        return view('add_admin', ['validation' => $this->userModel->errors()]);
    }

// get dashboard data
public function getStrategyMapData()
{
    // 1. Fetch all active themes
    $data['themes'] = $this->themesModel
        ->where('organization_id', $this->organization['id'])
        ->where('status', 'active')
        ->orderBy('id')
        ->get()
        ->getResultArray();

    // 2. Fetch all active perspectives
    $data['perspectives'] = $this->bscperspectivesModel
        ->where('organizations_id', $this->organization['id'])
        ->where('status', 'active')
        ->orderBy('id')
        ->get()
        ->getResultArray();

    // 3. Fetch all active goals (with joins)
    $goals = $this->goalsModel
        ->where('organization_id', $this->organization['id'])
        ->select('goals.description, goals.theme_id, goals.bscperspective_id')
        ->where('goals.status', 'active')
        ->findAll();

    // Separate goals with and without perspective
    $strategyMatrix = [
        'with_perspective' => [],
        'without_perspective' => []
    ];

    foreach ($goals as $goal) {
        if (!empty($goal['bscperspective_id'])) {
            $strategyMatrix['with_perspective'][] = $goal;
        } else {
            $strategyMatrix['without_perspective'][$goal['theme_id']][] = $goal['description'];
        }
    }

    $data['strategyMatrix'] = $strategyMatrix;
    $data['organization'] = $this->organization;

    return $data;
}


    // render view to create strategy map
    public function strategyMap()
    {
        $data = $this->getStrategyMapData();
        $action = $this->request->getGet('action');

        if ($action === 'download') {
            return view('downloads/strategy_map', $data);
        }

        return view('users/strategy_map', $data);
    }
    // fetch user specifics and return to their dashboard/home
    public function dashboard()
    {
        $role = session()->get('role');
        $data = [];

        if ($role === 'project_lead' || $role === 'department_head') {
            $slug = session()->get('user_slug');
            $initiatives = $this->initiativesController->getUserInitiatives($slug);

            $totalInitiatives = count($initiatives);
            $completedInitiatives = 0;
            $activeInitiatives = 0;
            $dueInitiatives = 0;

            $now = new DateTime(); // Define this once outside the loop

            foreach ($initiatives as $initiative) {
                // Get status and end date properly
                $status = is_object($initiative) ? $initiative->status : $initiative['status'];
                $endDate = new DateTime(is_object($initiative) ? $initiative->end_date : $initiative['end_date']);

                if ($status === 'completed') {
                    $completedInitiatives++;
                } elseif ($status === 'active') {
                    $activeInitiatives++;

                    // Check if due
                    if ($now > $endDate) {
                        $dueInitiatives++;
                    }
                }
            }


            $kpis = $this->kpisController->getUserKpis($slug);

            $totalKPIs = count($kpis);
            $completedKPIs = 0;
            $activeKPIs = 0;
            $dueKPIs = 0;

            $today = date('Y-m-d');

            foreach ($kpis as $kpi) {
                // Handle both object and array types
                $status = is_object($kpi) ? $kpi->status : $kpi['status'];
                $timeline = is_object($kpi) ? $kpi->timeline : $kpi['timeline'];

                if ($status === 'completed') {
                    $completedKPIs++;
                }
                if ($status === 'active') {
                    $activeKPIs++;

                    // Increment dueKPIs only if status is active and timeline has passed
                    if (!empty($timeline) && strtotime($timeline) < strtotime($today)) {
                        $dueKPIs++;
                    }
                }
            }


            $initiativeReports = $this->submissionsModel->where('project_type', 'initiative')->where('submitted_by', session()->get('user_id'))->findAll();
            $totalInitiativeReports = count($initiativeReports);
            $approvedInitiativeReports = 0;
            $pendingInitiativeReports = 0;
            $rejectedInitiativeReports = 0;

            foreach ($initiativeReports as $initiativeReport) {
                if ($initiativeReport['status'] === 'approved') {
                    $approvedInitiativeReports++;
                } elseif ($initiativeReport['status'] === 'pending') {
                    $pendingInitiativeReports++;
                } elseif ($initiativeReport['status'] === 'rejected') {
                    $rejectedInitiativeReports++;
                }
            }

            $kpiReports = $this->submissionsModel->where('project_type', 'kpi')->where('submitted_by', session()->get('user_id'))->findAll();
            $totalKPIReports = count($kpiReports);
            $approvedKPIReports = 0;
            $pendingKPIReports = 0;
            $rejectedKPIReports = 0;

            foreach ($kpiReports as $kpiReports) {
                if ($kpiReports['status'] === 'approved') {
                    $approvedKPIReports++;
                } elseif ($kpiReports['status'] === 'pending') {
                    $pendingKPIReports++;
                } elseif ($kpiReports['status'] === 'rejected') {
                    $rejectedKPIReports++;
                }
            }

            $data = [
                'initiatives' => $initiatives,
                'totalInitiatives' => $totalInitiatives,
                'completedInitiatives' => $completedInitiatives,
                'activeInitiatives' => $activeInitiatives,
                'dueInitiatives' => $dueInitiatives,
                'totalKPIs' => $totalKPIs,
                'completedKPIs' => $completedKPIs,
                'activeKPIs' => $activeKPIs,
                'dueKPIs' => $dueKPIs,
                'totalInitiativeReports' => $totalInitiativeReports,
                'approvedInitiativeReports' => $approvedInitiativeReports,
                'pendingInitiativeReports' => $pendingInitiativeReports,
                'rejectedInitiativeReports' => $rejectedInitiativeReports,
                'totalKPIReports' => $totalKPIReports,
                'approvedKPIReports' => $approvedKPIReports,
                'pendingKPIReports' => $pendingKPIReports,
                'rejectedKPIReports' => $rejectedKPIReports,
            ];
        }

        if ($role === 'superadmin' || $role === 'chief_strategy_officer' || $role === 'viewer') {
            $themes = $this->themesModel->where('organization_id', $this->organization['id'])->findAll();
            $completedThemes = 0;
            $activeThemes = 0;
            $dueThemes = 0;

            foreach ($themes as $theme) {
                if ($theme['status'] === 'completed') {
                    $completedThemes++;
                } elseif ($theme['status'] === 'active') {
                    $activeThemes++;
                }

                // Check if the theme is due (i.e., date has passed)
                if (!empty($theme['timeline']) && $theme['status'] !== 'completed' && $theme['status'] !== 'inactive' && strtotime($theme['timeline']) < time()) {
                    $dueThemes++;
                }
            }

            $totalThemes = $completedThemes + $activeThemes;

            $goals = $this->goalsModel
                ->select('goals.*, themes.timeline, themes.status as theme_status')
                ->join('themes', 'themes.id = goals.theme_id')
                ->where('goals.organization_id', $this->organization['id'])
                ->findAll();

            $completedGoals = 0;
            $activeGoals = 0;
            $dueGoals = 0;

            foreach ($goals as $goal) {
                if ($goal['status'] === 'completed') {
                    $completedGoals++;
                }
                if ($goal['status'] === 'active') {
                    $activeGoals++;
                }

                // Check if the theme is active and overdue
                if (
                    $goal['status'] !== 'completed' && $goal['status'] !== 'inactive' &&
                    $goal['theme_status'] !== 'completed' && $goal['theme_status'] !== 'inactive' &&
                    !empty($goal['timeline']) &&
                    strtotime($goal['timeline']) < time()
                ) {
                    $dueGoals++;
                }
            }

            // dd($goals);

            $totalGoals = $completedGoals + $activeGoals;

            $initiatives = $this->initiativesModel
                ->where('organization_id', $this->organization['id'])
                ->findAll();

            $completedInitiatives = 0;
            $activeInitiatives = 0;
            $dueInitiatives = 0;

            foreach ($initiatives as $initiative) {
                if ($initiative['status'] === 'completed') {
                    $completedInitiatives++;
                }
                if ($initiative['status'] === 'active') {
                    $activeInitiatives++;
                }

                // Check if the end_date has passed and status is not completed
                if (
                    $initiative['status'] !== 'completed' &&
                    $initiative['status'] !== 'inactive' &&
                    !empty($initiative['end_date']) &&
                    strtotime($initiative['end_date']) < time()
                ) {
                    $dueInitiatives++;
                }
            }

            $totalInitiatives = $completedInitiatives + $activeInitiatives;


            $kpis = $this->kpisModel->where('organization_id', $this->organization['id'])->findAll();
            $completedKPIs = 0;
            $activeKPIs = 0;
            $dueKPIs = 0;

            $today = date('Y-m-d');

            foreach ($kpis as $kpi) {
                // Handle both object and array types
                $status = is_object($kpi) ? $kpi->status : $kpi['status'];
                $timeline = is_object($kpi) ? $kpi->timeline : $kpi['timeline'];

                if ($status === 'completed') {
                    $completedKPIs++;
                }
                if ($status === 'active') {
                    $activeKPIs++;

                    // Increment dueKPIs only if status is active and timeline has passed
                    if (!empty($timeline) && strtotime($timeline) < strtotime($today)) {
                        $dueKPIs++;
                    }
                }
            }
            $totalKPIs = $completedKPIs + $activeKPIs;

            $initiativeReports = $this->submissionsModel->where('organization_id', $this->organization['id'])->where('project_type', 'initiative')->findAll();
            $totalInitiativeReports = count($initiativeReports);
            $approvedInitiativeReports = 0;
            $pendingInitiativeReports = 0;
            $rejectedInitiativeReports = 0;

            foreach ($initiativeReports as $initiativeReport) {
                if ($initiativeReport['status'] === 'approved') {
                    $approvedInitiativeReports++;
                } elseif ($initiativeReport['status'] === 'pending') {
                    $pendingInitiativeReports++;
                } elseif ($initiativeReport['status'] === 'rejected') {
                    $rejectedInitiativeReports++;
                }
            }

            $kpiReports = $this->submissionsModel->where('organization_id', $this->organization['id'])->where('project_type', 'kpi')->findAll();
            $totalKPIReports = count($kpiReports);
            $approvedKPIReports = 0;
            $pendingKPIReports = 0;
            $rejectedKPIReports = 0;

            foreach ($kpiReports as $kpiReports) {
                if ($kpiReports['status'] === 'approved') {
                    $approvedKPIReports++;
                } elseif ($kpiReports['status'] === 'pending') {
                    $pendingKPIReports++;
                } elseif ($kpiReports['status'] === 'rejected') {
                    $rejectedKPIReports++;
                }
            }

            $data = [
                'totalThemes' => $totalThemes,
                'completedThemes' => $completedThemes,
                'activeThemes' => $activeThemes,
                'dueThemes' => $dueThemes,
                'totalGoals' => $totalGoals,
                'completedGoals' => $completedGoals,
                'activeGoals' => $activeGoals,
                'dueGoals' => $dueGoals,
                'totalInitiatives' => $totalInitiatives,
                'completedInitiatives' => $completedInitiatives,
                'activeInitiatives' => $activeInitiatives,
                'dueInitiatives' => $dueInitiatives,
                'totalKPIs' => $totalKPIs,
                'completedKPIs' => $completedKPIs,
                'activeKPIs' => $activeKPIs,
                'dueKPIs' => $dueKPIs,
                'totalInitiativeReports' => $totalInitiativeReports,
                'approvedInitiativeReports' => $approvedInitiativeReports,
                'pendingInitiativeReports' => $pendingInitiativeReports,
                'rejectedInitiativeReports' => $rejectedInitiativeReports,
                'totalKPIReports' => $totalKPIReports,
                'approvedKPIReports' => $approvedKPIReports,
                'pendingKPIReports' => $pendingKPIReports,
                'rejectedKPIReports' => $rejectedKPIReports,
            ];
        }

        if ($role === 'admin') {
            $users = $this->userModel->where('organizations_id', $this->organization['id'])->findAll();
            $totalUsers = count($users);
            $activeUsers = 0;
            $inactiveUsers = 0;

            foreach ($users as $user) {
                if ($user['status'] === 'active') {
                    $activeUsers++;
                } elseif ($user['status'] === 'inactive') {
                    $inactiveUsers++;
                }
            }

            $data = [
                'totalUsers' => $totalUsers,
                'activeUsers' => $activeUsers,
                'inactiveUsers' => $inactiveUsers,
            ];
        }
        // dd($data);

        return view('users/dashboard', array_merge(
            ['organization' => $this->organization],
            $data
        ));
    }

    // display login form
    public function login_form()
    {
        $stracker = $this->customizationModel->first();

        if (!empty($stracker)) {
            session()->set([
                'logo' => $stracker['logo'],
            ]);
        }

        return view('login', ['stracker' => $stracker]);
    }

    public function login()
    {
        // dd('ok');
        $rules = [
            'email' => 'required',
            'password' => 'required',
        ];

        if (!$this->validate($rules)) {
            return view('login', ['validation' => $this->validator]);
        }

        $email = $this->request->getPost('email');
        $password = $this->request->getPost('password');

        $user = $this->userModel->where('email', $email)->first();

        if ($user && password_verify($password, $user['password'])) {
            if ($user['status'] === 'inactive') {

                return view('login', ['loginError' => 'Your account has been disabled']);
            }

            if ($user['role'] !== 'superadmin') {
                $this->organization = $this->organizationsModel->where('id', $user['organizations_id'])->first();
                // display error message if organization's account is inactive
                if ($this->organization['status'] === 'inactive') {
                    return view('login', ['loginError' => "Your organization's account is inactive"]);
                }
            }

            session()->set([
                'role' => $user['role'],
                'user_slug' => $user['slug'],
                'user_id' => $user['id'],
                'name' => $user['name'],
                'is_logged_in' => true
            ]);

            // Only set 'slug' if user is NOT a superadmin
            if ($user['role'] !== 'superadmin') {
                session()->set('slug', $this->organization['slug']);
            }

            // send superadmin to his dashboard
            if ($user['role'] === 'superadmin') {
                return redirect()->to('admin/dashboard');
            }

            session()->setFlashdata('success', 'Login successful');

            return redirect()->to('home');
        }
        $customization = $this->customizationModel->first();

        return view('login', ['loginError' => 'Email or password error! Note that passwords are case sensitive', 'customization' => $customization]);
    }

    // display page for password reset
    public function reset_password_form()
    {
        $customization = $this->customizationModel->first();

        return view('reset_password', ['customization' => $customization]);
    }

    //collect users email address and send them password reset link
    public function reset_password()
    {
        $rules = [
            'email' => 'required|valid_email',
        ];

        if (!$this->validate($rules)) {
            return view('reset_password', ['validation' => $this->validator]);
        }

        $email = $this->request->getPost('email');
        $user = $this->userModel->where('email', $email)->first();

        $customization = $this->customizationModel->first();
        if (!$user) {

            return view('reset_password', ['invalidUser' => 'User not found!', 'customization' => $customization]);
        }

        // Generate secure token and expiry time
        helper('text');
        $token = bin2hex(random_bytes(16)); // 32-char token
        $expires = date('Y-m-d H:i:s', strtotime('+30 minutes'));

        // Save token to user (or separate reset_tokens table if preferred)
        $this->userModel->update($user['id'], [
            'reset_token' => $token,
            'reset_expires_at' => $expires
        ]);

        // Create link
        $link = base_url("reset-password/confirm/$token");

        $subject = 'STracker Account Password Reset';
        $message = "<p style='margin-top:8px;'>Hello {$user['name']},</p>
            <p style='margin-top:8px;'>We received a reset password request for your account. If this was you, click the link below and follow the instructions to reset your password:</p>
            <p style='margin: 18px 0; text-align: center;'>
                <a href=\"$link\" style='background-color:#51585e; text-decoration:none; padding:12px 24px; border-radius:6px; color:white; display:inline-block;'>
                    Reset Password
                </a>
            </p>
            <p style='margin-top:8px;'>This link will expire in 30 minutes.</p>
            <p style='margin-top:8px;'>If this was not you, we suggest that you change your password</p>
            <strong style='margin-top:12px;'>Best Regards.</strong>
            <strong style='display:block;'>Learning Impact Model</strong>
            <div style='margin-top:12px; text-align: center; background-color:rgb(233, 233, 233); font-size:12px; padding:12px'>STracker | {$customization['lim_address']}</div>
            <h3 style='margin-top:8px; text-align: center;'>&copy; " . date('Y') . " Learning Impact Model</h3>";



        if ($this->email->sendMail($user['email'], $subject, $message)) {
            return redirect()->to('reset-password/message');
        }

        return view('reset_password', ['error' => 'Failed to send email. Try again later.']);
    }

    // display message after password reset link is sent to user
    public function reset_password_message()
    {
        return view('reset_password_message', ['status' => 'Your password reset request was successful. Check your email and follow the instructions.']);
    }

    // display form to collect new password
    public function reset_password_confirm_form($token)
    {
        $user = $this->userModel->where('reset_token', $token)->first();

        if (!$user) {
            return view('reset_password_message', ['status' => 'User not found or link expired']);
        }

        if (strtotime($user['reset_expires_at']) < time()) {
            return view('reset_password_message', ['status' => 'Your password reset link has expired']);
        }

        return view('reset_password_confirm', ['user' => $user]);
    }

    // collect new password and reset one in db
    public function reset_password_confirm($token)
    {
        $rules = [
            'password' => 'required|min_length[8]',
            'confirm_password' => 'required|matches[password]'
        ];

        if (!$this->validate($rules)) {
            return view('reset_password_confirm', [
                'validation' => $this->validator,
                'user' => $this->userModel->where('reset_token', $token)->first(),
            ]);
        }

        $user = $this->userModel->where('reset_token', $token)->first();

        if (!$user) {
            return view('reset_password_confirm', ['invalidUser' => 'User not found.']);
        }

        $password = $this->request->getPost('password');
        $hashedPassword = password_hash($password, PASSWORD_DEFAULT);

        $this->userModel->update($user['id'], [
            'password' => $hashedPassword,
            'reset_token' => null,
            'reset_expires_at' => null,
        ]);

        return redirect()->to('login')->with('success', 'Password updated successfully. Please login.');
    }

    // logout users
    public function logout()
    {
        session()->destroy();
        return redirect()->to('login');
    }

    // Get users with departments, optionally filtered by status
    public function getUsersWithDepartments($id)
    {
        $status = $this->request->getGet('status');

        $builder = $this->userModel
            ->select('users.*, organizationstructures.name as structure_name')
            ->join('organizationstructures', 'organizationstructures.id = users.organizationstructures_id', 'left')
            ->where('organizations_id', $id);

        if (!is_null($status)) {
            $builder->where('users.status', $status);
        }

        return $builder
            ->orderBy('users.status', 'ASC')
            ->orderBy('users.created_at', 'DESC')
            ->get()
            ->getResultArray();
    }


    // display form for admin to add users
    public function add_user_form()
    {
        $structures = $this->organizationStructureModel->where('status', 'active')->where('organization_id', $this->organization['id'])->findAll();
        // $users = $this->getUsersWithDepartments();
        // dd($users);

        return view('users/create', ['organization' => $this->organization, 'structures' => $structures]);
    }


    // collect user data, store in db and email password to user
    public function add_user()
    {
        $structures = $this->organizationStructureModel->where('status', 'active')->where('organization_id', $this->organization['id'])->findAll();

        $validationRules = [
            'type' => 'required',
            'name' => 'required|max_length[255]|string',
            'phone' => 'integer',
            'email' => 'required|valid_email|is_unique[users.email]',
        ];

        $validationMessages = [
            'type' => [
                'required' => 'Choose user category',
            ],
            'name' => [
                'required' => 'The name field is required.',
                'string'   => 'The name must be a valid string.',
            ],
            'phone' => [
                'integer' => 'Provide valid phone number',
            ],
            'email' => [
                'required'    => 'The email field is required.',
                'valid_email' => 'Please provide a valid email address.',
                'is_unique'   => 'This email has already been taken.'
            ],
        ];

        if (!$this->validate($validationRules, $validationMessages)) {
            return view('users/create', ['validation' => $this->validator, 'organization' => $this->organization, 'structures' => $structures]);
        }

        $passcode = substr(str_shuffle(bin2hex(random_bytes(4)) . 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz'), 0, 8);
        $hashedPassword = password_hash($passcode, PASSWORD_DEFAULT);

        $data = [
            'organizations_id' => $this->organization['id'],
            'slug' => substr(md5(uniqid(time(), true)), 0, 32),
            'organizationstructures_id' => $this->request->getPost('organizationstructures_id') ?: null,
            'role'     => $this->request->getPost('type'),
            'name'     => $this->request->getPost('name'),
            'phone'    => $this->request->getPost('phone'),
            'email'    => $this->request->getPost('email'),
            'password' => $hashedPassword,
            'passcode' => $passcode,
        ];

        // dd($data);
        $typeLabels = [
            'admin' => 'Admin',
            'chief_strategy_officer' => 'Chief Strategy Officer',
            'department_head' => 'Department Head',
            'project_lead' => 'Project Lead',
            'viewer' => 'Viewer',
        ];

        $userTypeKey = $data['role'];
        $userTypeLabel = $typeLabels[$userTypeKey] ?? 'User';
        $organizationName = $this->organization['name'];
        $stracker = $this->customizationModel->first();

        // Create link
        $link = base_url("login");

        $subject = 'New STracker Account';
        $message = "<p style='margin-top:8px;'>Hello {$data['name']},</p>
            <p style='margin-top:8px;'>$organizationName has created a $userTypeLabel account for you on STracker with the following details:</p>
            <p style='margin-top:8px;'><strong>Email:</strong> {$data['email']}</p>
            <p style='margin-top:8px;'><strong>Password:</strong> {$data['passcode']}</p>
            <p style='margin-top:8px;'>Click on the link below to login.</p>
            <p style='margin: 18px 0; text-align: center;'>
                <a href=\"$link\" style='background-color:#51585e; text-decoration:none; padding:12px 24px; border-radius:6px; color:white; display:inline-block;'>
                    Login
                </a>
            </p>
            <p style='margin-top:8px;'>If the above button does not work, copy this link and paste in your url address bar $link</p>
            <strong style='margin-top:12px;'>Best Regards.</strong>
            <strong style='display:block;'>Learning Impact Model</strong>
            <div style='margin-top:12px; text-align: center; background-color:rgb(233, 233, 233); font-size:12px; padding:12px'>STracker | {$stracker['lim_address']}</div>
            <h3 style='margin-top:8px; text-align: center;'>&copy; " . date('Y') . " Learning Impact Model</h3>";

        $users = $this->userModel->where('organizations_id', $this->organization['id'])->findAll();
        $total_users = count($users);
        
        if ($total_users >= $this->organization['max_users']) {
            return view('users/create', [
                'userError' => 'Your organization has reached its maximum number of users!',
                'organization' => $this->organization,
                'structures' => $structures
            ]);
        }
            
        if ($this->userModel->save($data)) {
            $this->email->sendMail($data['email'], $subject, $message);

            return redirect()->to('users')->with('success', 'User added successfully');
        }
    }

    // display form to edit user information
    public function edit_user_form($slug)
    {
        $structures = $this->organizationStructureModel->where('status', 'active')->where('organization_id', $this->organization['id'])->findAll();
        $user = $this->userModel->where('slug', $slug)->first();

        return view('users/edit', ['organization' => $this->organization, 'structures' => $structures, 'user' => $user]);
    }

    // collect data and update db
    public function update_user()
    {
        $id = $this->request->getPost('id');
        $user = $this->userModel->find($id);

        $structures = $this->organizationStructureModel->where('status', 'active')->where('organization_id', $this->organization['id'])->findAll();
        // dd($user);

        $validationRules = [
            'type' => 'required',
            'name' => 'required|max_length[255]|string',
            'email' => 'required|valid_email|is_unique[users.email,id,' . $id . ']',
        ];

        $validationMessages = [
            'type' => [
                'required' => 'Choose user category',
            ],
            'name' => [
                'required' => 'The name field is required',
                'string'   => 'The name must be a valid string',
            ],
            'phone' => [
                'integer' => 'Provide valid phone number',
            ],
            'email' => [
                'required'    => 'The email field is required',
                'valid_email' => 'Please provide a valid email address',
                'is_unique'   => 'This email has already been taken'
            ],
        ];

        if (!$this->validate($validationRules, $validationMessages)) {
            return view('users/edit', ['validation' => $this->validator, 'user' => $user, 'organization' => $this->organization, 'structures' => $structures]);
        }

        $data = [
            'organizationstructures_id' => $this->request->getPost('organizationstructures_id') ?: null,
            'role' => $this->request->getPost('type'),
            'name' => $this->request->getPost('name'),
            'phone' => $this->request->getPost('phone'),
            'email' => $this->request->getPost('email'),
        ];

        if ($this->userModel->update($id, $data)) {
            return redirect()->to('users')->with('success', 'User details updated successfully');
        }
    }

    // disable user
    public function disable($id)
    {
        // dd('ok');
        $data = [
            'status' => 'inactive',
        ];

        if ($this->userModel->update($id, $data)) {
            return redirect()->to('users')->with('success', 'User disabled successfully');
        }
        return redirect()->to('users')->with('error', 'Unable to disable user');
    }

    // enable user
    public function enable($id)
    {
        // dd('enable');
        $data = [
            'status' => 'active',
        ];

        if ($this->userModel->update($id, $data)) {
            return redirect()->to('users')->with('success', 'User enabled successfully');
        }
        return redirect()->to('users')->with('error', 'Unable to enable user');
    }

    // display form to change password
    public function change_password_form()
    {
        return view('users/change_password');
    }

    // collect user input and change password
    public function change_password()
    {
        $validationRules = [
            'old_password' => 'required',
            'new_password' => 'required|min_length[8]',
            'password_confirmation' => 'required|matches[new_password]',
        ];

        $validationMessages = [
            'old_password' => [
                'required' => 'Provide your old password',
            ],
            'new_password' => [
                'required'   => 'The new password is required',
                'min_length' => 'The new password must be up to 8 characters long',
            ],
            'password_confirmation' => [
                'required' => 'Please confirm your new password',
                'matches'  => 'Password confirmation does not match the new password',
            ],
        ];

        if (!$this->validate($validationRules, $validationMessages)) {
            return view('users/change_password', ['validation' => $this->validator]);
        }

        $old_password = $this->request->getPost('old_password');
        $new_password = $this->request->getPost('new_password');
        $user = $this->userModel->where('id', session()->get('user_id'))->first();

        if (password_verify($old_password, $user['password'])) {
            $data = [
                'password' => password_hash($new_password, PASSWORD_DEFAULT),
            ];

            if ($this->userModel->update($user['id'], $data)) {
                return redirect()->to('user/change-password')->with('success', 'Password changed successfully');
            }
        }
        return view('users/change_password', ['passwordError' => 'Error! Note that passwords are case sensitive']);
    }
}
