<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateOrganizationsTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'unsigned' => true,
                'auto_increment' => true,
            ],

            'slug' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
            ],

            'name' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
            ],

            'email' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
            ],

            'email_token' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
            ],

            'password' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
            ],

            'status' => [
                'type' => 'VARCHAR',
                'constraint' => '100',
                'default' => 'active',
            ],

            'passcode' => [
                'type' => 'VARCHAR',
                'constraint' => '100',
            ],

                       
            'logo' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
                'null' => true,
            ],

            'password_reset_token' => [
                'type' => 'VARCHAR',
                'constraint' => '100',
                'null' => true,
            ],

            'reset_expires_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],

            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],

            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],

        ]);

        $this->forge->addKey('id', true);

        $this->forge->createTable('organizations');
    }

    public function down()
    {
        $this->forge->dropTable('organizations');
    }
}
