<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateUsersTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'unsigned' => true,
                'auto_increment' => true,
            ],

            'organizations_id' => [
                'type' => 'INT',
                'unsigned' => true,
                'null' => true,
            ],

            'organizationstructures_id' => [
                'type' => 'INT',
                'unsigned' => true,
                'null' => true,
            ],

            'slug' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
            ],

            'role' => [
                'type' => 'VARCHAR',
                'constraint' => '100',
            ],

            'name' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
            ],

            'phone' => [
                'type' => 'VARCHAR',
                'constraint' => '100',
            ],

            'email' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
            ],

            'email_verified' => [
                'type' => 'VARCHAR',
                'constraint' => '100',
                'default' => false,
            ],

            'password' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
            ],

            'status' => [
                'type' => 'VARCHAR',
                'constraint' => '100',
                'default' => 'active',
            ],

            'passcode' => [
                'type' => 'VARCHAR',
                'constraint' => '100',
            ],

            'reset_token' => [
                'type' => 'VARCHAR',
                'constraint' => '100',
                'null' => true,
            ],

            'reset_expires_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],

            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],

            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ]

        ]);

        $this->forge->addKey('id', true);

        $this->forge->addForeignKey('organizations_id', 'organizations', 'id', 'CASCADE', 'CASCADE');
        $this->forge->createTable('users');
    }

    public function down()
    {
        $this->forge->dropTable('users');
    }
}
