<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateCustomizationsTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'unsigned' => true,
                'auto_increment' => true,
            ],

            'lim_address' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
            ],

            'logo' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
            ],

            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],

            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ]

        ]);

        $this->forge->addKey('id', true);

        $this->forge->createTable('customizations');
    }

    public function down()
    {
        $this->forge->dropTable('customizations');
    }
}
