<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateBSCPerspectivesTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'unsigned' => true,
                'auto_increment' => true,
            ],

            'organizations_id' => [
                'type' => 'INT',
                'unsigned' => true,
            ],

            'slug' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
            ],

            'name' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
            ],

            'status' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
                'default' => 'active',
            ],

            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],

            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ]

        ]);

        $this->forge->addKey('id', true);

        $this->forge->addForeignKey('organizations_id', 'organizations', 'id', 'CASCADE', 'CASCADE');
        $this->forge->createTable('bscperspectives');
    }

    public function down()
    {
        $this->forge->dropTable('bscperspectives');
    }
}