<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateOrganzationStructureTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'unsigned' => true,
                'auto_increment' => true,
            ],

            'organization_id' => [
                'type' => 'INT',
                'unsigned' => true,
            ],

            'parent_id' => [
                'type' => 'INT',
                'unsigned' => true,
                'null' => true,
            ],

            'slug' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
            ],

            'type' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
            ],

            'name' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
            ],

            'status' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
                'default' => 'active',
            ],

            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],

            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ]

        ]);

        $this->forge->addKey('id', true);
        $this->forge->addForeignKey('organization_id', 'organizations', 'id', 'CASCADE', 'CASCADE');
        $this->forge->addForeignKey('parent_id', 'organizationstructures', 'id', 'CASCADE', 'CASCADE');

        $this->forge->createTable('organizationstructures');
    }

    public function down()
    {
        $this->forge->dropTable('organizationstructures');
    }
}
