<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateGoalsTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'unsigned' => true,
                'auto_increment' => true,
            ],

            'organization_id' => [
                'type' => 'INT',
                'unsigned' => true,
            ],

            'theme_id' => [
                'type' => 'INT',
                'unsigned' => true,
            ],

            'bscperspective_id' => [
                'type' => 'INT',
                'unsigned' => true,
                'null' => true,
            ],

            'slug' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
            ],

            'description' => [
                'type' => 'TEXT',
            ],

            'status' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
                'default' => 'active',
            ],

            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],

            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ]

        ]);

        $this->forge->addKey('id', true);
        $this->forge->addForeignKey('organization_id', 'organizations', 'id', 'CASCADE', 'CASCADE');
        $this->forge->addForeignKey('theme_id', 'themes', 'id', 'CASCADE', 'CASCADE');
        $this->forge->addForeignKey('bscperspective_id', 'bscperspectives', 'id', 'CASCADE', 'CASCADE');

        $this->forge->createTable('goals');
    }

    public function down()
    {
        $this->forge->dropTable('goals');
    }
}
