<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateInitiativesTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'unsigned' => true,
                'auto_increment' => true,
            ],

            'organization_id' => [
                'type' => 'INT',
                'unsigned' => true,
            ],

            'goal_id' => [
                'type' => 'INT',
                'unsigned' => true,
            ],

            'slug' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
            ],

            'name' => [
                'type' => 'TEXT',
            ],

            'slug' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
            ],

            'target' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
            ],

            'start_date' => [
                'type' => 'DATE',
            ],

            'end_date' => [
                'type' => 'DATE',
            ],

            'measure_of_success' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
            ],

            'current_status' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
                'default' => 'in_progress',
            ],

            'rag_status' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
                'default' => 'amber',
            ],

            'status' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
                'default' => 'active',
            ],

            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],

            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ]

        ]);

        $this->forge->addKey('id', true);
        $this->forge->addForeignKey('organization_id', 'organizations', 'id', 'CASCADE', 'CASCADE');
        $this->forge->addForeignKey('goal_id', 'goals', 'id', 'CASCADE', 'CASCADE');

        $this->forge->createTable('initiatives');
    }

    public function down()
    {
        $this->forge->dropTable('initiatives');
    }
}
