<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateKPIsTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'unsigned' => true,
                'auto_increment' => true,
            ],

            'organization_id' => [
                'type' => 'INT',
                'unsigned' => true,
            ],

            'initiative_id' => [
                'type' => 'INT',
                'unsigned' => true,
            ],

            'slug' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
            ],

            'name' => [
                'type' => 'TEXT',
            ],

            'timeline' => [
                'type' => 'DATE',
            ],

            'status' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
                'default' => 'active',
            ],

            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],

            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
        ]);

        $this->forge->addKey('id', true);
        $this->forge->addForeignKey('organization_id', 'organizations', 'id', 'CASCADE', 'CASCADE');
        $this->forge->addForeignKey('initiative_id', 'initiatives', 'id', 'CASCADE', 'CASCADE');

        $this->forge->createTable('kpis');
    }

    public function down()
    {
        $this->forge->dropTable('kpis');
    }
}
