<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateKPIOwnersTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'unsigned' => true,
                'auto_increment' => true,
            ],

            'slug' => [
                'type' => 'VARCHAR',
                'constraint' => 100,
            ],

            'organization_id' => [
                'type' => 'INT',
                'unsigned' => true,
            ],

            'kpi_id' => [
                'type' => 'INT',
                'unsigned' => true,
            ],

            'organizationstructure_owner_id' => [
                'type' => 'INT',
                'unsigned' => true,
                'null' => true,
            ],

            'individual_owner_id' => [
                'type' => 'INT',
                'unsigned' => true,
                'null' => true,
            ],

            'status' => [
                'type' => 'VARCHAR',
                'constraint' => 20,
                'default' => 'active',
            ],


            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],

            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ]

        ]);

        $this->forge->addKey('id', true);
        $this->forge->addForeignKey('organization_id', 'organizations', 'id', 'CASCADE', 'CASCADE');
        $this->forge->addForeignKey('kpi_id', 'kpis', 'id', 'CASCADE', 'CASCADE');
        $this->forge->addForeignKey('organizationstructure_owner_id', 'organizationstructures', 'id', 'CASCADE', 'CASCADE');
        $this->forge->addForeignKey('individual_owner_id', 'users', 'id', 'CASCADE', 'CASCADE');

        $this->forge->createTable('kpiowners');
    }

    public function down()
    {
        $this->forge->dropTable('kpiowners');
    }
}
