<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateSubmissionsTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'unsigned' => true,
                'auto_increment' => true,
            ],

            'slug' => [
                'type' => 'VARCHAR',
                'constraint' => '100',
            ],

            'organization_id' => [
                'type' => 'INT',
                'unsigned' => true,
            ],

            'project_type' => [
                'type' => 'VARCHAR',
                'constraint' => 100,
            ],

            'initiative_id' => [
                'type' => 'INT',
                'unsigned' => true,
                'null' => true,
            ],

            'kpi_id' => [
                'type' => 'INT',
                'unsigned' => true,
                'null' => true,
            ],

            'submitted_by' => [
                'type' => 'INT',
                'unsigned' => true,
                'null' => true,
            ],

            'cso_id' => [
                'type' => 'INT',
                'unsigned' => true,
                'null' => true,
            ],

            'submitted_comment' => [
                'type' => 'TEXT',
            ],

            'cso_comment' => [
                'type' => 'TEXT',
                'null' => true,
            ],

            'approved_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],

            'document_link' => [
                'type' => 'VARCHAR',
                'constraint' => 200,
                'null' => true,
            ],

            'percentage_of_completion' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
                'null' => true,
            ],

            'status' => [
                'type' => 'VARCHAR',
                'constraint' => 20,
                'default' => 'pending',
            ],

            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],

            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ]

        ]);

        $this->forge->addKey('id', true);
        $this->forge->addForeignKey('organization_id', 'organizations', 'id', 'CASCADE', 'CASCADE');
        $this->forge->addForeignKey('initiative_id', 'initiatives', 'id', 'CASCADE', 'CASCADE');
        $this->forge->addForeignKey('kpi_id', 'kpis', 'id', 'CASCADE', 'CASCADE');
        $this->forge->addForeignKey('submitted_by', 'users', 'id', 'CASCADE', 'CASCADE');
        $this->forge->addForeignKey('cso_id', 'users', 'id', 'CASCADE', 'CASCADE');

        $this->forge->createTable('submissions');
    }

    public function down()
    {
        $this->forge->dropTable('submissions');
    }
}
