<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateCommentsTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'unsigned' => true,
                'auto_increment' => true,
            ],

            'slug' => [
                'type' => 'VARCHAR',
                'constraint' => '100',
            ],

            'organization_id' => [
                'type' => 'INT',
                'unsigned' => true,
            ],

            'project_type' => [
                'type' => 'VARCHAR',
                'constraint' => 100,
            ],

            'initiative_id' => [
                'type' => 'INT',
                'unsigned' => true,
                'null' => true,
            ],

            'kpi_id' => [
                'type' => 'INT',
                'unsigned' => true,
                'null' => true,
            ],

            'user_id' => [
                'type' => 'INT',
                'unsigned' => true,
            ],

            'comment_body' => [
                'type' => 'TEXT',
            ],

            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],

            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ]

        ]);

        $this->forge->addKey('id', true);
        $this->forge->addForeignKey('organization_id', 'organizations', 'id', 'CASCADE', 'CASCADE');
        $this->forge->addForeignKey('initiative_id', 'initiatives', 'id', 'CASCADE', 'CASCADE');
        $this->forge->addForeignKey('kpi_id', 'kpis', 'id', 'CASCADE', 'CASCADE');
        $this->forge->addForeignKey('user_id', 'users', 'id', 'CASCADE', 'CASCADE');

        $this->forge->createTable('comments');
    }

    public function down()
    {
        $this->forge->dropTable('comments');
    }
}
