<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateEmailsTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'unsigned' => true,
                'auto_increment' => true,
            ],

            'slug' => [
                'type' => 'VARCHAR',
                'constraint' => '100',
            ],

            'organization_id' => [
                'type' => 'INT',
                'unsigned' => true,
            ],

            'sent_by' => [
                'type' => 'INT',
                'unsigned' => true,
            ],

            'subject' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
            ],

            'body' => [
                'type' => 'TEXT',
            ],

            'status' => [
                'type' => 'VARCHAR',
                'constraint' => 20,
                'default' => 'pending',
            ],

            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],

            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ]

        ]);

        $this->forge->addKey('id', true);
        $this->forge->addForeignKey('organization_id', 'organizations', 'id', 'CASCADE', 'CASCADE');
        $this->forge->addForeignKey('sent_by', 'users', 'id', 'CASCADE', 'CASCADE');

        $this->forge->createTable('emails');
    }

    public function down()
    {
        $this->forge->dropTable('emails');
    }
}
