<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateEmailRecipientsTable extends Migration
{
     public function up()
    {
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'unsigned' => true,
                'auto_increment' => true,
            ],

            'organization_id' => [
                'type' => 'INT',
                'unsigned' => true,
            ],

            'email_id' => [
                'type' => 'INT',
                'unsigned' => true,
            ],

            'recipient_id' => [
                'type' => 'INT',
                'unsigned' => true,
                'null' => true,
            ],

            'structure_id' => [
                'type' => 'INT',
                'unsigned' => true,
                'null' => true,
            ],

            'email_address' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
            ],

            'status' => [
                'type' => 'VARCHAR',
                'constraint' => 20,
                'default' => 'pending',
            ],

            'sent_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],

            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],

            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ]

        ]);

        $this->forge->addKey('id', true);
        $this->forge->addForeignKey('organization_id', 'organizations', 'id', 'CASCADE', 'CASCADE');
        $this->forge->addForeignKey('recipient_id', 'users', 'id', 'CASCADE', 'CASCADE');
        $this->forge->addForeignKey('structure_id', 'organizationstructures', 'id', 'CASCADE', 'CASCADE');
        $this->forge->addForeignKey('email_id', 'emails', 'id', 'CASCADE', 'CASCADE');

        $this->forge->createTable('emailrecipients');
    }

    public function down()
    {
        $this->forge->dropTable('emailrecipients');
    }
}
