<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateNotificationEmailsTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'unsigned' => true,
                'auto_increment' => true,
            ],

            'organization_id' => [
                'type' => 'INT',
                'unsigned' => true,
            ],

            'recipient_name' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
            ],

            'recipient_email' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
            ],

            'type' => [ //initiative or kpi
                'type' => 'VARCHAR',
                'constraint' => 255,
            ],

            'name' => [
                'type' => 'TEXT',
            ],

            'status' => [
                'type' => 'VARCHAR',
                'constraint' => 20,
                'default' => 'pending',
            ],

            'timeline' => [
                'type' => 'DATE',
            ],

            'sent_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],

            'notify_stage' => [
                'type' => 'DECIMAL',
                'null' => true,
            ],

            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],

            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ]

        ]);

        $this->forge->addKey('id', true);
        $this->forge->addForeignKey('organization_id', 'organizations', 'id', 'CASCADE', 'CASCADE');

        $this->forge->createTable('notificationemails');
    }

    public function down()
    {
        $this->forge->dropTable('notificationemails');
    }
}
