<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class BSCPerspectivesSeeder extends Seeder
{
    public function run()
    {
        $perspectives = ['Financial Perspective', 'People Perspective', 'Process Perspective', 'Customer Perspective'];

        // Get all organizations
        $organizations = $this->db->table('organizations')->select('id')->get()->getResultArray();

        foreach ($organizations as $org) {
            foreach ($perspectives as $perspective) {
                $data = [
                    'organizations_id' => $org['id'],
                    'slug'             => substr(md5(uniqid(time(), true)), 0, 40),
                    'name'             => $perspective,
                    'status'           => 'active',
                    'created_at'       => date('Y-m-d H:i:s'),
                    'updated_at'       => date('Y-m-d H:i:s'),
                ];

                $this->db->table('bscperspectives')->insert($data);
            }
        }
    }
}
