<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;
use Faker\Factory;

class CommentsSeeder extends Seeder
{
    public function run()
    {
        $faker = Factory::create();

        // Fetch all users with their organization
        $usersByOrg = [];
        $users = $this->db->table('users')
            ->select('id, organizations_id')
            ->get()
            ->getResultArray();

        foreach ($users as $user) {
            $usersByOrg[$user['organizations_id']][] = $user['id'];
        }

        // Comments for initiatives
        $initiatives = $this->db->table('initiatives')
            ->select('id, organization_id')
            ->get()
            ->getResultArray();

        foreach ($initiatives as $initiative) {
            $orgId = $initiative['organization_id'];

            if (!empty($usersByOrg[$orgId])) {
                $userId = $faker->randomElement($usersByOrg[$orgId]);

                $data = [
                    'slug'             => substr(md5(uniqid(rand(), true)), 0, 40),
                    'organization_id'  => $orgId,
                    'project_type'     => 'initiative',
                    'initiative_id'    => $initiative['id'],
                    'user_id'          => $userId,
                    'comment_body'     => $faker->sentence(12),
                    'created_at'       => date('Y-m-d H:i:s'),
                    'updated_at'       => date('Y-m-d H:i:s'),
                ];

                $this->db->table('comments')->insert($data);
            }
        }

        // Comments for KPIs
        $kpis = $this->db->table('kpis')
            ->select('id, organization_id')
            ->get()
            ->getResultArray();

        foreach ($kpis as $kpi) {
            $orgId = $kpi['organization_id'];

            if (!empty($usersByOrg[$orgId])) {
                $userId = $faker->randomElement($usersByOrg[$orgId]);

                $data = [
                    'slug'             => substr(md5(uniqid(rand(), true)), 0, 40),
                    'organization_id'  => $orgId,
                    'project_type'     => 'kpi',
                    'kpi_id'           => $kpi['id'],
                    'user_id'          => $userId,
                    'comment_body'     => $faker->sentence(12),
                    'created_at'       => date('Y-m-d H:i:s'),
                    'updated_at'       => date('Y-m-d H:i:s'),
                ];

                $this->db->table('comments')->insert($data);
            }
        }
    }
}
