<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;
use Faker\Factory;

class GoalsSeeder extends Seeder
{
    public function run()
    {
        $faker = Factory::create();

        // Fetch all themes (active only)
        $themes = $this->db->table('themes')
            ->select('id, organization_id')
            ->where('status', 'active')
            ->get()
            ->getResultArray();

        foreach ($themes as $theme) {
            // Get BSC perspectives that belong to the theme's organization
            $bscPerspectives = $this->db->table('bscperspectives')
                ->select('id')
                ->where('organizations_id', $theme['organization_id'])
                ->get()
                ->getResultArray();

            $perspectiveIds = array_column($bscPerspectives, 'id');

            foreach ($perspectiveIds as $perspectiveId) {
                $data = [
                    'organization_id'   => $theme['organization_id'],
                    'theme_id'          => $theme['id'],
                    'bscperspective_id' => $perspectiveId,
                    'slug'              => substr(md5(uniqid(time(), true)), 0, 40),
                    'description'       => $faker->sentence(10),
                    'status'            => 'active',
                    'created_at'        => date('Y-m-d H:i:s'),
                    'updated_at'        => date('Y-m-d H:i:s'),
                ];

                $this->db->table('goals')->insert($data);
            }
        }
    }
}
