<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class InitiativeOwnersSeeder extends Seeder
{
    public function run()
    {
        // Get all initiatives with their organization IDs
        $initiatives = $this->db->table('initiatives')
            ->select('id, organization_id')
            ->get()
            ->getResultArray();

        foreach ($initiatives as $initiative) {
            $organizationId = $initiative['organization_id'];

            // Get organization structures and users that belong to this organization
            $orgStructures = $this->db->table('organizationstructures')
                ->select('id')
                ->where('organization_id', $organizationId)
                ->get()
                ->getResultArray();

            $users = $this->db->table('users')
                ->select('id')
                ->where('organizations_id', $organizationId)
                ->get()
                ->getResultArray();

            // Randomly assign one structure and user, if available
            $orgStructureId = !empty($orgStructures)
                ? $orgStructures[array_rand($orgStructures)]['id']
                : null;

            $userId = !empty($users)
                ? $users[array_rand($users)]['id']
                : null;

            $data = [
                'organization_id'               => $organizationId,
                'initiative_id'                 => $initiative['id'],
                'organizationstructure_owner_id'=> $orgStructureId,
                'individual_owner_id'           => $userId,
                'status'                        => 'active',
                'created_at'                    => date('Y-m-d H:i:s'),
                'updated_at'                    => date('Y-m-d H:i:s'),
            ];

            $this->db->table('initiativeowners')->insert($data);
        }
    }
}
