<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;
use Faker\Factory;

class InitiativesSeeder extends Seeder
{
    public function run()
    {
        $faker = Factory::create();

        // Get all goals with their organization_id
        $goals = $this->db->table('goals')
            ->select('id, organization_id')
            ->get()
            ->getResultArray();

        foreach ($goals as $goal) {
            // Create 2 initiatives per goal
            for ($i = 0; $i < 3; $i++) {
                $startDate = $faker->dateTimeBetween('-1 months', 'now');
                $endDate = $faker->dateTimeBetween($startDate, '+12 months');

                $data = [
                    'organization_id'    => $goal['organization_id'],
                    'goal_id'            => $goal['id'],
                    'slug'               => substr(md5(uniqid(time(), true)), 0, 40),
                    'name'               => $faker->sentence(6),
                    'target'             => $faker->numberBetween(50, 100) . '%',
                    'start_date'         => $startDate->format('Y-m-d'),
                    'end_date'           => $endDate->format('Y-m-d'),
                    'measure_of_success' => $faker->randomElement(['quality', 'budget', 'time']),
                    'current_status'     => $faker->randomElement(['in_progress', 'completed']),
                    'rag_status'         => $faker->randomElement(['green', 'amber', 'red']),
                    'status'             => 'active',
                    'created_at'         => date('Y-m-d H:i:s'),
                    'updated_at'         => date('Y-m-d H:i:s'),
                ];

                $this->db->table('initiatives')->insert($data);
            }
        }
    }
}
