<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class KPIOwnersSeeder extends Seeder
{
    public function run()
    {
        // Get all KPIs with their organization ID
        $kpis = $this->db->table('kpis')
            ->select('id, organization_id')
            ->get()
            ->getResultArray();

        foreach ($kpis as $kpi) {
            // Fetch organization-specific structures
            $orgStructures = $this->db->table('organizationstructures')
                ->select('id')
                ->where('organization_id', $kpi['organization_id'])
                ->get()
                ->getResultArray();

            // Fetch users under that organization
            $users = $this->db->table('users')
                ->select('id')
                ->where('organizations_id', $kpi['organization_id'])
                ->get()
                ->getResultArray();

            $orgStructureIds = array_column($orgStructures, 'id');
            $userIds = array_column($users, 'id');

            $data = [
                'slug'                         => substr(md5(uniqid(time(), true)), 0, 40),
                'organization_id'              => $kpi['organization_id'],
                'kpi_id'                       => $kpi['id'],
                'organizationstructure_owner_id' => !empty($orgStructureIds) ? $orgStructureIds[array_rand($orgStructureIds)] : null,
                'individual_owner_id'          => !empty($userIds) ? $userIds[array_rand($userIds)] : null,
                'status'                       => 'active',
                'created_at'                   => date('Y-m-d H:i:s'),
                'updated_at'                   => date('Y-m-d H:i:s'),
            ];

            $this->db->table('kpiowners')->insert($data);
        }
    }
}
