<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class KPIsSeeder extends Seeder
{
    public function run()
    {
        // Get all initiatives with their organization IDs
        $initiatives = $this->db->table('initiatives')
            ->select('id, organization_id')
            ->get()
            ->getResultArray();

        foreach ($initiatives as $initiative) {
            $data = [
                'organization_id' => $initiative['organization_id'],
                'initiative_id'   => $initiative['id'],
                'slug'            => substr(md5(uniqid(time(), true)), 0, 40),
                'name'            => 'KPI for Initiative ' . $initiative['id'],
                'timeline'        => date('Y-m-d', strtotime('+1 year')),
                'status'          => 'active',
                'created_at'      => date('Y-m-d H:i:s'),
                'updated_at'      => date('Y-m-d H:i:s'),
            ];

            $this->db->table('kpis')->insert($data);
        }
    }
}
