<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;
use Faker\Factory;

class OrganizationStructuresSeeder extends Seeder
{
    public function run()
    {
        $faker = Factory::create();

        // Get existing organization IDs
        $organizationIds = $this->db->table('organizations')->select('id')->get()->getResultArray();
        $structureTypes = ['unit', 'departments', 'SBUs', 'divisions'];

        $insertedIds = [];

        // Seed 10 organization structures
        for ($i = 0; $i < 10; $i++) {
            $organizationId = $faker->randomElement($organizationIds)['id'] ?? null;

            $data = [
                'organization_id' => $organizationId,
                'slug'            => substr(md5(uniqid(time(), true)), 0, 40),
                'type'            => $faker->randomElement($structureTypes),
                'name'            => $faker->company . ' Structure',
                'status'          => 'active',
                'created_at'      => date('Y-m-d H:i:s'),
                'updated_at'      => date('Y-m-d H:i:s'),
            ];

            $this->db->table('organizationstructures')->insert($data);
            $insertedIds[] = $this->db->insertID(); // track inserted IDs for possible parent selection
        }
    }
}
