<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;
use Faker\Factory;

class OrganizationsSeeder extends Seeder
{
    public function run()
    {
        $faker = Factory::create();

        // You can change this number to seed more or fewer records
        for ($i = 0; $i < 10; $i++) {
            $data = [
                'slug'                 => substr(md5(uniqid(time(), true)), 0, 40),
                'name'                 => $faker->company,
                'email'                => $faker->unique()->companyEmail,
                'password'             => password_hash('password', PASSWORD_DEFAULT),
                'status'               => 'active',
                'passcode'             => 'password',
                'logo'                 => $faker->imageUrl(200, 200, 'business'),
                'created_at'           => date('Y-m-d H:i:s'),
                'updated_at'           => date('Y-m-d H:i:s'),
            ];

            $this->db->table('organizations')->insert($data);
        }
    }
}
