<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;
use Faker\Factory;

class SubmissionsSeeder extends Seeder
{
    public function run()
    {
        $faker = Factory::create();

        // Fetch initiative owners
        $initiativeOwners = $this->db->table('initiativeowners')
            ->select('id, organization_id, initiative_id, individual_owner_id')
            ->get()
            ->getResultArray();

        // Fetch KPI owners
        $kpiOwners = $this->db->table('kpiowners')
            ->select('id, organization_id, kpi_id, individual_owner_id')
            ->get()
            ->getResultArray();

        $documentLinks = [
            'https://picsum.photos/200/300',
            'https://www.w3.org/WAI/ER/tests/xhtml/testfiles/resources/pdf/dummy.pdf'
        ];

        // Create submissions for initiatives
        foreach ($initiativeOwners as $owner) {
            $data = [
                'slug'              => substr(md5(uniqid(rand(), true)), 0, 40),
                'organization_id'   => $owner['organization_id'],
                'project_type'      => 'initiative',
                'initiative_id'     => $owner['initiative_id'],
                'submitted_by'      => $owner['individual_owner_id'],
                'submitted_comment' => $faker->paragraph,
                'document_link'     => $faker->randomElement($documentLinks),
                'status'            => 'pending',
                'created_at'        => date('Y-m-d H:i:s'),
                'updated_at'        => date('Y-m-d H:i:s'),
            ];

            $this->db->table('submissions')->insert($data);
        }

        // Create submissions for KPIs
        foreach ($kpiOwners as $owner) {
            $data = [
                'slug'              => substr(md5(uniqid(rand(), true)), 0, 40),
                'organization_id'   => $owner['organization_id'],
                'project_type'      => 'kpi',
                'kpi_id'            => $owner['kpi_id'],
                'submitted_by'      => $owner['individual_owner_id'],
                'submitted_comment' => $faker->paragraph,
                'document_link'     => $faker->randomElement($documentLinks),
                'status'            => 'pending',
                'created_at'        => date('Y-m-d H:i:s'),
                'updated_at'        => date('Y-m-d H:i:s'),
            ];

            $this->db->table('submissions')->insert($data);
        }
    }
}
