<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;
use Faker\Factory;

class ThemesSeeder extends Seeder
{
    public function run()
    {
        $faker = Factory::create();

        // Get all organizations
        $organizations = $this->db->table('organizations')->select('id')->get()->getResultArray();

        foreach ($organizations as $org) {
            // Get all BSC perspectives for this organization
            $bscperspectives = $this->db->table('bscperspectives')
                ->select('id')
                ->where('organizations_id', $org['id'])
                ->get()
                ->getResultArray();

            // Seed 3 themes per organization
            for ($i = 0; $i < 4; $i++) {
                $data = [
                    'organization_id'   => $org['id'],
                    'bscperspective_id' => $faker->randomElement($bscperspectives)['id'] ?? null,
                    'slug'              => substr(md5(uniqid(time(), true)), 0, 40),
                    'title'             => $faker->sentence(6),
                    'description'       => $faker->paragraph,
                    'timeline'          => $faker->dateTimeBetween('now', '+1 year')->format('Y-m-d'),
                    'status'            => 'active',
                    'created_at'        => date('Y-m-d H:i:s'),
                    'updated_at'        => date('Y-m-d H:i:s'),
                ];

                $this->db->table('themes')->insert($data);
            }
        }
    }
}
