<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;
use Faker\Factory;

class UsersSeeder extends Seeder
{
    public function run()
    {
        $faker = Factory::create();

        // Get existing organization IDs to assign to users
        $organizationIds = $this->db->table('organizations')->select('id')->get()->getResultArray();

        // You can change the number of users to seed here
        for ($i = 0; $i < 10; $i++) {
            $organizationId = $faker->randomElement($organizationIds)['id'] ?? null;

            $data = [
                'organizations_id'         => $organizationId,
                'organizationstructures_id'=> null, // Adjust if related seeder/table exists
                'slug'                     => substr(md5(uniqid(time(), true)), 0, 32),
                'role'                     => $faker->randomElement(['superadmin', 'admin', 'chief_strategy_officer', 'department_head', 'project_lead', 'viewer']),
                'name'                     => $faker->name,
                'phone'                    => $faker->phoneNumber,
                'email'                    => $faker->unique()->safeEmail,
                'email_verified'           => $faker->randomElement(['true', 'false']),
                'password'                 => password_hash('password', PASSWORD_DEFAULT),
                'status'                   => 'active',
                'passcode'                 => 'password',
                'created_at'               => date('Y-m-d H:i:s'),
                'updated_at'               => date('Y-m-d H:i:s'),
            ];

            $this->db->table('users')->insert($data);
        }
    }
}
