<?php

namespace App\Validation;

class CustomRules
{
    public function valid_date_range(): bool
    {
        $request = service('request');
        $startDate = $request->getPost('start_date'); // or getVar()
        $endDate = $request->getPost('end_date'); // or getVar()

        if (!$startDate || !$endDate) {
            $error = 'Start and End dates are required.';
            return false;
        }

        if (strtotime($endDate) < strtotime($startDate)) {
            $error = 'End date must be after or equal to start date.';
            return false;
        }

        return true;
    }

    // make sure at least one owner is chosen in assigning initiatives
    public function atLeastOneOwner() : bool
    {
        $request = service('request');
        $orgId = $request->getPost('organizationstructure_owner_id');
        $indId = $request->getPost('individual_owner_id');

        if(empty($orgId) && empty($indId)){
            return false;
        }
        return true;
    }
}

