<?= $this->extend('components/html_boiler.php') ?>

<?= $this->section('content') ?>

<div class="bg-light w-75 mx-auto mt-5 p-5">
    <h1 class="text-center large-text">STracker</h1>
    <h4 class="text-center medium-text">Add Super-admin to get started</h4>
    <form action="<?= base_url('add/superadmin') ?>" method="post" class="p-4 mx-auto" style="min-height: 70%;" x-data="formSubmit" @submit.prevent="submit">
    <?= csrf_field() ?>

        <div class="row">
            <div class="mb-3 col-6">
                <label for="name" class="form-label">Name</label>
                <input type="text" class="form-input" name="name" placeholder="Name" value="<?= set_value('name') ?>">
                <p class="text-danger"><?= isset($validation['name']) ? $validation['name'] : '' ?></p>
            </div>

            <div class="mb-3 col-6">
                <label for="phone" class="form-label">Phone <small class="text-muted">(Optional)</small></label>
                <input type="number" class="form-input" name="phone" placeholder="Phone" value="<?= set_value('phone') ?>">
                <p class="text-danger"><?= isset($validation['phone']) ? $validation['phone'] : '' ?></p>
            </div>

            <div class="mb-3 col-6">
                <label for="email" class="form-label">Email</label>
                <input type="text" class="form-input" name="email" placeholder="Email" value="<?= set_value('email') ?>">
                <p class="text-danger"><?= isset($validation['email']) ? $validation['email'] : '' ?></p>
            </div>

            <div class="mb-3 col-6">
                <label for="password" class="form-label">Password</label>
                <input type="password" class="form-input" name="password" placeholder="Password">
                <p class="text-danger"><?= isset($validation['password']) ? $validation['password'] : '' ?></p>
            </div>
        </div>

        <button class="btn btn-pink w-100" x-ref="btn">Add Admin</button>
    </form>
</div>
<?= $this->endSection() ?>