<?= $this->extend('components/html_boiler.php') ?>

<?= $this->section('content') ?>
<?= $this->include('components/navbar') ?>
<?= $this->include('components/sidebar') ?>

<main id="main" class="main">

    <?php if (!empty($organization)) : ?>
        <div class="pagetitle">
            <h1><?= esc($organization['name']) ?? '' ?></h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?= base_url('home') ?>">Home</a></li>
                    <li class="breadcrumb-item"><a href="<?= base_url('bscperspectives') ?>">Strategy Framework Perspective</a></li>
                    <li class="breadcrumb-item active"><a href="#">New</a></li>
                </ol>
            </nav>
        </div><!-- End Page Title -->
    <?php endif; ?>

    <section class="section dashboard">
        <div class="row g-4">

            <!-- Organizations -->

            <div class="col-lg-9">
                <div class="card recent-sales overflow-auto">

                    <div class="card-body">
                        <h1 class="my-4 medium-text">Add Strategy Framework Perspective</h1>

                        <form action="<?= base_url('create/bscperspectives') ?>" method="post" style="min-height: 70%;" x-data="formSubmit" @submit.prevent="submit">
                            <?= csrf_field() ?>
                            <input type="hidden" name="id" value="<?= $organization['id'] ?>">

                            <div class="mb-3">
                                <label for="name" class="form-label">Name</label>
                                <input type="text" class="form-input" name="name">
                                <p class="text-danger"><?= isset($validation) ? $validation->showError('name') : '' ?></p>
                            </div>

                            <button class="btn btn-pink w-100" x-ref="btn">Save</button>

                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
</main>
<?= $this->endSection() ?>