<?= $this->extend('components/html_boiler.php') ?>

<?= $this->section('content') ?>
<?= $this->include('components/navbar') ?>
<?= $this->include('components/sidebar') ?>

<main id="main" class="main">

    <?php if (!empty($organization)) : ?>
        <div class="pagetitle">
            <h1><?= esc($organization['name']) ?? '' ?></h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?= base_url('home') ?>">Home</a></li>
                    <li class="breadcrumb-item active"><a href="<?= base_url('chats') ?>">Chats</a></li>
                </ol>
            </nav>
        </div><!-- End Page Title -->
    <?php endif; ?>

    <section class="section dashboard">
        <div class="row g-4">

            <!-- Organizations -->

            <div class="col-12">
                <div class="card recent-sales overflow-auto">

                    <div class="card-body">

                        <div class="filter text-end">
                            <a class="icon" href="#" id="filter" data-bs-toggle="dropdown"><i class="fa fa-ellipsis-h"></i></a>
                            <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow">
                                <li class="dropdown-header text-start">
                                    <h6>Filter</h6>
                                </li>

                                <li><a class="dropdown-item" href="<?= base_url('chats?status=active') ?>">Active</a></li>
                                <li><a class="dropdown-item" href="<?= base_url('chats?status=inactive') ?>">Inactive</a></li>
                                <li><a class="dropdown-item" href="<?= base_url('chats') ?>">All</a></li>
                            </ul>
                        </div>

                        <?php if (!empty($organization)) : ?>
                            <h5 class="card-title large-text">Chats
                                <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#chatmodal">
                                    New Chat
                                </button>
                                <div class="modal fade" id="chatmodal" tabindex="-1">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <form action="<?= base_url('chats/create') ?>" method="post" style="min-height: 70%;" x-data="formSubmit" @submit.prevent="submit">
                                                <div class="modal-header">
                                                    <h5 class="modal-title">Start A New Conversation</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <?= csrf_field() ?>
                                                    <input type="hidden" name="id" value="<?= $organization['id'] ?>">

                                                    <div class="row">
                                                        <div class="mb-3 col-12">
                                                            <label for="title" class="form-label">Title</label>
                                                            <input type="text" class="form-input" name="title" value="<?= set_value('title') ?>">
                                                            <p class="text-danger"><?= isset($validation) ? $validation->showError('title') : '' ?></p>
                                                        </div>
                                                    </div>

                                                </div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                                    <button type="submit" class="btn btn-primary" x-ref="btn">Create Chat</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div><!-- End Basic Modal-->

                            </h5>

                        <?php endif; ?>
                        <?php if (!empty($chats)) : ?>
    <div class="list-group chat-list">
        <?php foreach ($chats as $chat) : ?>
            <a href="<?= base_url('chats/view?chat=' . $chat['slug']) ?>" 
               class="list-group-item list-group-item-action d-flex align-items-center">
                
                <!-- Avatar or icon -->
                <div class="chat-avatar me-3">
                    <i class="fa fa-comments fa-2x text-primary"></i>
                </div>

                <!-- Chat info -->
                <div class="flex-fill">
                    <div class="d-flex justify-content-between">
                        <h6 class="mb-1"><?= esc($chat['title']) ?></h6>
                        <small class="text-muted">
                            <?= (new DateTime($chat['created_at']))->format('d M Y') ?>
                        </small>
                    </div>
                    <p class="mb-0 text-muted">
                        Initiated by <?= esc($chat['initiator_name']) ?>
                    </p>
                </div>

                <!-- Status/Actions -->
                <div class="ms-3 d-flex align-items-center">
                    <a href="<?= base_url('chats/view?chat=' . $chat['slug']) ?>" class="btn btn-outline-secondary btn-sm me-2">
                        <i class="fa fa-eye"></i>
                    </a>
                    <?php if (in_array(session()->get('role'), ['superadmin', 'chief_strategy_officer'])): ?>
                        <?php if ($chat['status'] === 'active') : ?>
                            <form action="<?= base_url('chats/disable/' . esc($chat['id'])) ?>" method="post" class="m-0">
                                <?= csrf_field() ?>
                                <button class="btn btn-outline-danger btn-sm" title="Deactivate" type="submit">
                                    <i class="fa fa-power-off"></i>
                                </button>
                            </form>
                        <?php else: ?>
                            <form action="<?= base_url('chats/enable/' . esc($chat['id'])) ?>" method="post" class="m-0">
                                <?= csrf_field() ?>
                                <button class="btn btn-outline-warning btn-sm" title="Activate" type="submit">
                                    <i class="fa fa-toggle-on"></i>
                                </button>
                            </form>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
            </a>
        <?php endforeach; ?>
    </div>
<?php else : ?>
    <div class="alert alert-info">No chats found</div>
<?php endif; ?>

                    </div>

                </div>
            </div><!-- end users -->
        </div>
    </section>
</main>

<?= $this->endSection() ?>