<?= $this->extend('components/html_boiler.php') ?>

<?= $this->section('content') ?>
<?= $this->include('components/navbar') ?>
<?= $this->include('components/sidebar') ?>

<main id="main" class="main">

    <?php if (!empty($organization)) : ?>
        <div class="pagetitle">
            <h1><?= esc($organization['name']) ?? '' ?></h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?= base_url('home') ?>">Home</a></li>
                    <li class="breadcrumb-item"><a href="<?= base_url('chats') ?>">Chats</a></li>
                </ol>
            </nav>
        </div><!-- End Page Title -->
    <?php endif; ?>

    <section class="section dashboard">
        <div class="row g-4">

            <div class="col-12">

                <?php if (!empty($chat)) : ?>
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-body p-3" style="max-height: 70vh; overflow-y: auto;">
                                    <h5 class="card-title mb-4"><?= esc($chat['title']) ?></h5>

                                    <?php if (!empty($messages)) : ?>
                                        <?php foreach ($messages as $message): ?>
                                            <?php $isOwn = ($message['user_id'] == session()->get('user_id')); ?>

                                            <div class="d-flex mb-3 <?= $isOwn ? 'justify-content-end' : 'justify-content-start' ?>">
                                                <div class="p-3 rounded shadow-sm position-relative"
                                                     style="
                                                         max-width: 70%;
                                                         background-color: <?= $isOwn ? '#d1e7dd' : '#f8f9fa' ?>;
                                                         border-radius: 1rem;
                                                         <?= $isOwn ? 'border-bottom-right-radius: 0;' : 'border-bottom-left-radius: 0;' ?>
                                                     ">

                                                    <!-- Reply button -->
                                                    <?php if ($chat['status'] === 'active') : ?>
                                                    <button title="Reply" type="button" data-bs-toggle="modal" data-bs-target="#<?= esc($message['id']) ?>verticalycentered"
                                                        class="btn btn-sm position-absolute" 
                                                        style="top: 5px; right: 5px; background: transparent; border: none; padding: 0;">
                                                        <i class="fa fa-reply text-muted" style="font-size: 18px;"></i>
                                                    </button>

                                                    <!-- Reply modal -->
                                                    <div class="modal fade" id="<?= esc($message['id']) ?>verticalycentered" tabindex="-1">
                                                        <div class="modal-dialog modal-dialog-centered">
                                                            <div class="modal-content">
                                                                <div class="modal-body">
                                                                    <form action="<?= base_url('message/reply/create') ?>" method="post" style="min-height: 70%;" x-data="formSubmit" @submit.prevent="submit">
                                                                        <div class="modal-header">
                                                                            <h5 class="modal-title">Reply</h5>
                                                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                                        </div>
                                                                        <div class="modal-body">
                                                                            <?= csrf_field() ?>
                                                                            <input type="hidden" name="id" value="<?= $organization['id'] ?>">
                                                                            <input type="hidden" name="message_id" value="<?= $message['id'] ?>">
                                                                            <input type="hidden" name="chat_id" value="<?= $chat['id'] ?>">

                                                                            <div class="row">
                                                                                <div class="mb-3 col-12">
                                                                                    <label for="message_reply" class="form-label">Message</label>
                                                                                    <input type="text" class="form-input" name="message_reply" value="<?= set_value('message_reply') ?>">
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        <div class="modal-footer">
                                                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                                                            <button type="submit" class="btn btn-primary" x-ref="btn">Reply</button>
                                                                        </div>
                                                                    </form>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <?php endif; ?>

                                                    <!-- Reply preview -->
                                                    <?php if (!empty($message['reply_message'])): ?>
                                                        <div class="p-2 mb-2 rounded" style="background-color: rgba(0,0,0,0.05); font-size: 0.85rem;">
                                                            <small class="text-muted">
                                                                <?= esc($message['reply_sender_name']) ?>:
                                                            </small>
                                                            <div class="text-muted">
                                                                <?= esc($message['reply_message']) ?>
                                                            </div>
                                                        </div>
                                                    <?php endif; ?>

                                                    <!-- Actual message -->
                                                    <small class="fw-bold text-muted"><?= esc($message['sender_name']) ?></small>
                                                    <p class="mb-1"><?= esc($message['message']) ?></p>
                                                    <small class="text-muted" style="font-size: 0.75rem;">
                                                        <?= (new DateTime($message['created_at']))->format('d M Y, h:i A') ?>
                                                    </small>
                                                </div>
                                            </div>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <div class="alert alert-info">No messages found</div>
                                    <?php endif; ?>
                                </div>

                                <!-- Message input (below messages) -->
                                <?php if ($chat['status'] === 'active') : ?>
                                    <div class="card-footer">
                                        <form action="<?= base_url('chats/reply') ?>" method="post" class="p-3" x-data="formSubmit" @submit.prevent="submit" enctype="multipart/form-data">
                                            <?= csrf_field() ?>
                                            <input type="hidden" value="<?= $chat['id'] ?>" name="id">
                                            <div class="mb-2">
                                                <label for="message" class="form-label">Message</label>
                                                <textarea name="message" class="form-input" rows="3"><?= set_value('message') ?></textarea>
                                                <p class="text-danger"><?= isset($validation) ? $validation->showError('message') : '' ?></p>
                                            </div>
                                            <button class="btn btn-pink w-100" x-ref="btn">Send</button>
                                        </form>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>
</main>
<?= $this->endSection() ?>
