<?= $this->extend('components/html_boiler.php') ?>

<?= $this->section('content') ?>
<?= $this->include('components/navbar') ?>
<?= $this->include('components/sidebar') ?>

<main id="main" class="main">

    <?php if (!empty($organization)) : ?>
        <div class="pagetitle">
            <h1><?= esc($organization['name']) ?? '' ?></h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?= base_url('home') ?>">Home</a></li>
                    <li class="breadcrumb-item"><a href="#">Initiatives</a></li>
                    <li class="breadcrumb-item active"><a href="#">Comments</a></li>
                </ol>
            </nav>
        </div><!-- End Page Title -->
    <?php endif; ?>

    <section class="section dashboard">
        <div class="row g-4">

            <!-- Organizations -->

            <div class="col-12">

                <?php if (!empty($initiative)) : ?>

                    <div class="row">
                        <?php if (!empty($comments)) : ?>
                            <div class="col-lg-8">
                                <div class="card recent-sales overflow-auto">

                                    <div class="card-body">
                                        <h5 class="card-title large-text">Comments</h5>
                                    </div>
                                </div>
                                <?php foreach ($comments as $comment) : ?>
                                    <div class="card border-primary mb-3">
                                        <div class="card-header text-primary"><?= $comment['user'] ?></div>
                                        <div class="card-body">
                                            <p class="card-text"><?= $comment['comment_body'] ?></p>
                                            <p class="card-text mt-3">
                                                <span class="text-muted"><?= (new DateTime($comment['created_at']))->format('h:i A d M Y') ?></span>
                                            </p>
                                        </div>
                                    </div>

                                <?php endforeach; ?>
                            </div>
                        <?php else: ?>
                            <div class="col-lg-8">
                                <div class="card">

                                    <div class="card-body">
                                        <h5 class="card-title large-text">Comments</h5>
                                        <div class="alert alert-info">No comments found</div>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>

                        <?php if ($initiative['status'] === 'active') : ?>
                            <div class="col-lg-4">
                                <div class="card recent-sales overflow-auto">

                                    <div class="card-body">
                                        <h4 class="text-center medium-text card-title">Add Comment</h4>
                                        <form action="<?= base_url('my-initiatives/' . esc($initiative['slug']) . '/comments') ?>" method="post" class="p-4 mx-auto" style="min-height: 70%;" x-data="formSubmit" @submit.prevent="submit" enctype="multipart/form-data">
                                            <?= csrf_field() ?>
                                            <input type="hidden" value="<?= $initiative['id'] ?>" name="id">
                                            <div class="row">

                                                <div class="mb-1 col-12">
                                                    <label for="comment" class="form-label">Comment</label>
                                                    <textarea name="comment" class="form-input" rows="5"><?= set_value('comment') ?></textarea>
                                                    <p class="text-danger"><?= isset($validation) ? $validation->showError('comment') : '' ?></p>
                                                </div>

                                            </div>

                                            <button class="btn btn-pink w-100" x-ref="btn">Save</button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            </div><!-- end Organizations -->
        </div>
    </section>
</main>
<?= $this->endSection() ?>