
<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title>STracker</title>
  <meta  name="description" content="STracker is a web-based strategy tracking application designed to help organizations effectively manage and monitor their corporate strategies, initiatives, and key performance indicators (KPIs)">
  <meta content="Strategy, Performance, Management, Learning, Impact, Model" name="keywords">

  <!-- Favicons -->
  <link rel="shortcut icon" href="<?= base_url('favicon.png') ?>" type="image/png">
  <link href="<?= base_url('favicon.png') ?>" rel="apple-touch-icon">

  <meta property="og:url" content="<?= base_url('login') ?>">
  <meta property="og:type" content="Page" />
  <meta property="og:title" content="STracker | Learning Impact Model">
  <meta property="og:description" content="STracker is a web-based strategy tracking application designed to help organizations effectively manage and monitor their corporate strategies, initiatives, and key performance indicators (KPIs)">
  <meta property="og:image" content="<?= base_url('assets/img/lim.jpg') ?>">

  <!-- Google Fonts -->
  <link href="https://fonts.gstatic.com" rel="preconnect">
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

  <!-- google icons -->
  <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
  <!-- Bootstrap css -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.5/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- toastr alert -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" />

  <!-- apine js -->
  <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
  <!-- font-awesome -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
  <!-- custom/asset css -->
  <link rel="stylesheet" href="<?= base_url('assets/css/pre-loader.css') ?>">
  <link rel="stylesheet" href="<?= base_url('assets/css/simple-datatables.css') ?>">
  <link rel="stylesheet" href="<?= base_url('assets/css/style.css') ?>">
  <!-- bootstrap icons -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
  <!-- chart js -->
  <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

  <!-- tinymice -->
<script src="https://cdn.tiny.cloud/1/ghg9u4y00frvbtoqec5wv6oyaqei4047kfu7bnwkn1v2jpvu/tinymce/7/tinymce.min.js" referrerpolicy="origin"></script>

<!--manifest json for mobile app-->
<link rel="manifest" href="<?= base_url('manifest.json') ?>">
<meta name="theme-color" content="#007bff">


</head>

<body>
  <div class="wrapper">
    <!-- Preloader -->
    <div id="preloader"></div>

    <?= $this->renderSection('content') ?>

    <!-- ======= Footer ======= -->
    <footer id="footer" class="footer">
      <div class="copyright">
        &copy; Copyright <?= date('Y') ?> <strong><span>Learning Impact Model</span></strong>. All Rights Reserved
      </div>
      <div class="credits">
        Designed by <a href="https://learningimpactmodel.com/" target="_blank">Learning Impact Model</a>
      </div>
    </footer><!-- End Footer -->


    <a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>



    <!-- bootstrap js -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.5/dist/js/bootstrap.bundle.min.js"></script>
    <!-- toastr alert -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>

    <script src="<?= base_url('assets/js/pre-loader.js') ?>"></script>
    <script src="<?= base_url('assets/js/apine.js') ?>"></script>
    <script src="https://cdn.jsdelivr.net/npm/simple-datatables@latest" type="text/javascript"></script>
    <script src="<?= base_url('assets/js/form.js') ?>"></script>
    <script src="<?= base_url('assets/js/main.js') ?>"></script>

    <!-- tinymice editor -->
    <script>
      tinymce.init({
        selector: '#editor',
        plugins: [
          // Core editing features
          'anchor', 'autolink', 'charmap', 'codesample', 'emoticons', 'image', 'link', 'lists', 'media', 'searchreplace', 'table', 'visualblocks', 'wordcount',
          // Your account includes a free trial of TinyMCE premium features

        ],
        toolbar: 'undo redo | blocks fontfamily fontsize | bold italic underline strikethrough | link image media table mergetags | addcomment showcomments | spellcheckdialog a11ycheck typography | align lineheight | checklist numlist bullist indent outdent | emoticons charmap | removeformat',
        tinycomments_mode: 'embedded',
        tinycomments_author: 'Author name',
        mergetags_list: [{
            value: 'First.Name',
            title: 'First Name'
          },
          {
            value: 'Email',
            title: 'Email'
          },
        ],
        ai_request: (request, respondWith) => respondWith.string(() => Promise.reject('See docs to implement AI Assistant')),
      });
    </script>

    <?= $this->include('components/alert') ?>
  </div>
  
  <script>
  if ('serviceWorker' in navigator) {
    window.addEventListener('load', function() {
      navigator.serviceWorker.register('<?= base_url('sw.js') ?>')
        .then(function(reg) {
          console.log('service Worker registered with scope:', reg.scope);
        })
        .catch(function(err) {
          console.log('service worker registration failed:', err);
        });
    });
  }
</script>


</body>

</html>