<!-- ======= Sidebar ======= -->
<aside id="sidebar" class="sidebar">

  <ul class="sidebar-nav" id="sidebar-nav">
    <?php if (in_array(session()->get('role'), ['superadmin'])): ?>

      <li class="nav-item">
        <a class="nav-link <?= strpos(uri_string(), 'admin/dashboard') !== false ? '' : 'collapsed' ?> <?= strpos(uri_string(), 'admin/dashboard') !== false ? 'active' : '' ?>" href="<?= base_url('admin/dashboard') ?>">
          <i class="fa fa-dashboard" style="font-size:24px"></i>
          <span>Dashboard</span>
        </a>
      </li><!-- End dashboard Page Nav -->

      <li class="nav-item">
        <a class="nav-link <?= strpos(uri_string(), 'organizations') !== false ? '' : 'collapsed' ?> <?= strpos(uri_string(), 'organizations') !== false ? 'active' : '' ?>" href="<?= base_url('organizations') ?>">
          <i class="fa fa-user" style="font-size:24px"></i>
          <span>Organizations</span>
        </a>
      </li><!-- End Organizations Page Nav -->
    <?php endif; ?>

    <?php if (session()->has('slug')) : ?>
      <li class="nav-item">
        <a class="nav-link <?= strpos(uri_string(), 'home') !== false ? '' : 'collapsed' ?> <?= strpos(uri_string(), 'home') !== false ? 'active' : '' ?>" href="<?= base_url('home') ?>">
          <i class="fa fa-home" style="font-size:24px"></i>
          <span>Home</span>
        </a>
      </li><!-- End Dashboard Nav -->

      <?php if (in_array(session()->get('role'), ['superadmin', 'admin', 'chief_strategy_officer'])): ?>
        <?php
        // Determine if any Customization menu item is active
        $isCustomizationActive =
          strpos(uri_string(), 'organization') !== false ||
          strpos(uri_string(), 'structure') !== false ||
          strpos(uri_string(), 'bscperspectives') !== false;
        ?>
        <li class="nav-item">
          <a class="nav-link <?= $isCustomizationActive ? '' : 'collapsed' ?>" data-bs-target="#customization-nav" data-bs-toggle="collapse" href="#">
            <i class="fa fa-cog fa-spin" style="font-size:24px"></i><span>Customization</span><i class="fa fa-angle-down ms-auto" style="font-size:40px"></i>
          </a>
          <ul id="customization-nav" class="nav-content collapse <?= $isCustomizationActive ? 'show' : '' ?>" data-bs-parent="#sidebar-nav">
            <?php if (in_array(session()->get('role'), ['viewer', 'superadmin', 'admin'])): ?>
              <li class="nav-item">
                <a class="nav-link <?= strpos(uri_string(), 'organization') !== false ? 'active' : 'collapsed' ?>" href="<?= base_url('organization/update/' . session()->get('slug')) ?>">
                  <i class="bi bi-circle"></i>
                  <span>Organization</span>
                </a>
              </li><!-- End organization Page Nav -->

              <li class="nav-item">
                <a class="nav-link <?= strpos(uri_string(), 'structure') !== false ? 'active' : 'collapsed' ?>" href="<?= base_url('structures') ?>">
                  <i class="bi bi-circle"></i>
                  <span>Organization Structure</span>
                </a>
              </li><!-- End structure Page Nav -->
            <?php endif; ?>

            <?php if (in_array(session()->get('role'), ['superadmin', 'chief_strategy_officer'])): ?>
              <li class="nav-item">
                <a class="nav-link <?= strpos(uri_string(), 'bscperspectives') !== false ? 'active' : 'collapsed' ?>" href="<?= base_url('bscperspectives') ?>">
                  <i class="bi bi-circle"></i>
                  <span>Strategy Framework</span>
                </a>
              </li><!-- End BSC Perspectives Page Nav -->
            <?php endif; ?>
          </ul>
        </li><!-- End customization Nav -->
      <?php endif; ?>

      <li class="nav-item">
        <a class="nav-link <?= (uri_string() === 'strategy-map') ? 'active' : 'collapsed' ?>" href="<?= base_url('strategy-map') ?>">
          <i class="fa fa-line-chart"></i>
          <span>Strategy Map</span>
        </a>
      </li><!-- End strategy map Nav -->

      <?php if (in_array(session()->get('role'), ['viewer', 'superadmin', 'admin', 'chief_strategy_officer'])): ?>
        <li class="nav-item">
          <a class="nav-link <?= strpos(uri_string(), 'users') !== false ? 'active' : 'collapsed' ?>" href="<?= base_url('users') ?>">
            <i class="fa fa-user" style="font-size:24px"></i>
            <span>Users</span>
          </a>
        </li><!-- End users Page Nav -->
      <?php endif; ?>
      <?php if (in_array(session()->get('role'), ['viewer', 'superadmin', 'project_lead', 'department_head', 'admin', 'chief_strategy_officer'])): ?>

        <li class="nav-item">
          <a class="nav-link <?= strpos(uri_string(), 'themes') !== false ? 'active' : 'collapsed' ?>" href="<?= base_url('themes') ?>">
            <i class="fa fa-align-center" style="font-size:24px"></i>
            <span>Strategic Themes</span>
          </a>
        </li><!-- End themes Page Nav -->

        <li class="nav-item">
          <a class="nav-link <?= strpos(uri_string(), 'goals') !== false ? 'active' : 'collapsed' ?>" href="<?= base_url('goals') ?>">
            <i class="fa fa-dropbox" style="font-size:24px"></i>
            <span>High Level Goals</span>
          </a>
        </li><!-- End goals Page Nav -->

        <?php if (in_array(session()->get('role'), ['viewer', 'superadmin', 'chief_strategy_officer'])): ?>
          <li class="nav-item">
            <a class="nav-link <?= strpos(uri_string(), 'initiatives') !== false ? 'active' : 'collapsed' ?>" href="<?= base_url('initiatives') ?>">
              <i class="fa fa-bullhorn" style="font-size:24px"></i>
              <span>Initiatives</span>
            </a>
          </li><!-- End Initiatives Page Nav -->
        <?php endif; ?>
      <?php endif; ?>

      <?php if (in_array(session()->get('role'), ['project_lead', 'department_head'])): ?>
        <li class="nav-item">
          <a class="nav-link <?= strpos(uri_string(), 'my-initiatives') !== false ? 'active' : 'collapsed' ?>" href="<?= base_url('user/' . session()->get('user_slug') . '/my-initiatives') ?>">
            <i class="fa fa-align-center" style="font-size:24px"></i>
            <span>My Initiatives</span>
          </a>
        </li><!-- End my initiatives Page Nav -->

        <li class="nav-item">
          <a class="nav-link <?= strpos(uri_string(), 'my-kpis') !== false ? 'active' : 'collapsed' ?>" href="<?= base_url('user/' . session()->get('user_slug') . '/my-kpis') ?>">
            <i class="fa fa-align-center" style="font-size:24px"></i>
            <span>My KPIs</span>
          </a>
        </li><!-- End my initiatives Page Nav -->
      <?php endif; ?>

      <?php if (in_array(session()->get('role'), ['viewer', 'chief_strategy_officer', 'superadmin'])): ?>
        <?php
        // Determine if any initiaitve reports menu item is active
        $isInitiativeReportActive = (strpos(uri_string(), 'reports') === 0 && isset($_GET['type']) && $_GET['type'] === 'initiative');
        ?>

        <li class="nav-item">
          <a class="nav-link <?= $isInitiativeReportActive ? '' : 'collapsed' ?>" data-bs-target="#initiativereports-nav" data-bs-toggle="collapse" href="#">
            <i class="fa fa-address-book-o"></i><span>Initiative Reports</span><i class="fa fa-angle-down ms-auto" style="font-size:40px"></i>
          </a>
          <ul id="initiativereports-nav" class="nav-content collapse <?= $isInitiativeReportActive ? 'show' : '' ?>" data-bs-parent="#sidebar-nav">
            <li class="nav-item">
              <a class="nav-link <?= (uri_string() === 'reports'
                                    && (isset($_GET['type']) && $_GET['type'] === 'initiative')
                                    && (isset($_GET['status']) && $_GET['status'] === 'pending'))
                                    ? 'active'
                                    : 'collapsed' ?>" href="<?= base_url('reports?type=initiative&status=pending') ?>">
                <i class="bi bi-circle"></i>
                <span>Pending Reports</span>
              </a>
            </li><!-- End pending initiaitve reports Nav -->

            <li class="nav-item">
              <a class="nav-link <?= (uri_string() === 'reports'
                                    && (isset($_GET['type']) && $_GET['type'] === 'initiative')
                                    && (isset($_GET['status']) && $_GET['status'] === 'approved'))
                                    ? 'active'
                                    : 'collapsed' ?>" href="<?= base_url('reports?type=initiative&status=approved') ?>">
                <i class="bi bi-circle"></i>
                <span>Approved Reports</span>
              </a>
            </li><!-- End approved initiaitve reports Nav -->

            <li class="nav-item">
              <a class="nav-link <?= (uri_string() === 'reports'
                                    && (isset($_GET['type']) && $_GET['type'] === 'initiative')
                                    && (isset($_GET['status']) && $_GET['status'] === 'rejected'))
                                    ? 'active'
                                    : 'collapsed' ?>" href="<?= base_url('reports?type=initiative&status=rejected') ?>">
                <i class="bi bi-circle"></i>
                <span>Rejected Reports</span>
              </a>
            </li><!-- End BSC rejected initiaitve reports Page Nav -->
          </ul>
        </li><!-- End initiaitve reports Nav -->

        <?php
        // Determine if any kpi reports menu item is active
        $isKPIReportActive = (strpos(uri_string(), 'reports') === 0 && isset($_GET['type']) && $_GET['type'] === 'kpi');
        ?>

        <li class="nav-item">
          <a class="nav-link <?= $isKPIReportActive ? '' : 'collapsed' ?>" data-bs-target="#kpireports-nav" data-bs-toggle="collapse" href="#">
            <i class="fa fa-address-book-o"></i><span>KPI Reports</span><i class="fa fa-angle-down ms-auto" style="font-size:40px"></i>
          </a>
          <ul id="kpireports-nav" class="nav-content collapse <?= $isKPIReportActive ? 'show' : '' ?>" data-bs-parent="#sidebar-nav">
            <li class="nav-item">
              <a class="nav-link <?= (uri_string() === 'reports'
                                    && (isset($_GET['type']) && $_GET['type'] === 'kpi')
                                    && (isset($_GET['status']) && $_GET['status'] === 'pending'))
                                    ? 'active'
                                    : 'collapsed' ?>" href="<?= base_url('reports?type=kpi&status=pending') ?>">
                <i class="bi bi-circle"></i>
                <span>Pending Reports</span>
              </a>
            </li><!-- End pending kpi reports Nav -->

            <li class="nav-item">
              <a class="nav-link <?= (uri_string() === 'reports'
                                    && (isset($_GET['type']) && $_GET['type'] === 'kpi')
                                    && (isset($_GET['status']) && $_GET['status'] === 'approved'))
                                    ? 'active'
                                    : 'collapsed' ?>" href="<?= base_url('reports?type=kpi&status=approved') ?>">
                <i class="bi bi-circle"></i>
                <span>Approved Reports</span>
              </a>
            </li><!-- End approved kpi reports Nav -->

            <li class="nav-item">
              <a class="nav-link <?= (uri_string() === 'reports'
                                    && (isset($_GET['type']) && $_GET['type'] === 'kpi')
                                    && (isset($_GET['status']) && $_GET['status'] === 'rejected'))
                                    ? 'active'
                                    : 'collapsed' ?>" href="<?= base_url('reports?type=kpi&status=rejected') ?>">
                <i class="bi bi-circle"></i>
                <span>Rejected Reports</span>
              </a>
            </li><!-- End  rejected kpi reports Page Nav -->
          </ul>
        </li><!-- End kpi reports Nav -->
      <?php endif; ?>

      <?php if (in_array(session()->get('role'), ['superadmin', 'chief_strategy_officer'])): ?>
    <!-- chats -->
    <li class="nav-item">
      <a class="nav-link <?= strpos(uri_string(), 'emails') !== false ? 'active' : 'collapsed' ?>" href="<?= base_url('emails') ?>">
        <i class="fa fa-envelope" style="font-size:24px"></i>
        <span>Email Broadcasts</span>
      </a>
    </li><!-- End emails Page Nav -->
    <?php endif; ?>

    <!-- chats -->
    <li class="nav-item">
      <a class="nav-link <?= strpos(uri_string(), 'chats') !== false ? 'active' : 'collapsed' ?>" href="<?= base_url('chats') ?>">
        <i class="fa fa-comments" style="font-size:24px"></i>
        <span>Chats</span>
      </a>
    </li><!-- End chats Page Nav -->
    <?php endif; ?>

    <?php if (in_array(session()->get('role'), ['superadmin'])): ?>
      <?php
      // Determine if any Customization menu item is active
      $isSettingsActive =
        strpos(uri_string(), 'settings') !== false ||
        strpos(uri_string(), 'contacts') !== false ||
        strpos(uri_string(), 'subscriptions') !== false ||
        strpos(uri_string(), 'superadmin') !== false;
      ?>
      <li class="nav-item">
        <a class="nav-link <?= $isSettingsActive ? '' : 'collapsed' ?>" data-bs-target="#settings-nav" data-bs-toggle="collapse" href="#">
          <i class="fa fa-cog fa-spin" style="font-size:24px"></i><span>Settings</span><i class="fa fa-angle-down ms-auto" style="font-size:40px"></i>
        </a>
        <ul id="settings-nav" class="nav-content collapse <?= $isSettingsActive ? 'show' : '' ?>" data-bs-parent="#sidebar-nav">
          <?php if (in_array(session()->get('role'), ['viewer', 'superadmin', 'admin'])): ?>
            <li class="nav-item">
              <a class="nav-link <?= strpos(uri_string(), 'superadmin') !== false ? 'active' : 'collapsed' ?>" href="<?= base_url('superadmins') ?>">
                <i class="bi bi-circle"></i>
                <span>Super Admins</span>
              </a>
            </li>
            <li class="nav-item">
              <a class="nav-link <?= strpos(uri_string(), 'contacts') !== false ? 'active' : 'collapsed' ?>" href="<?= base_url('contacts') ?>">
                <i class="bi bi-circle"></i>
                <span>Contacts</span>
              </a>
            </li>
            
            <li class="nav-item">
              <a class="nav-link <?= strpos(uri_string(), 'subscriptions') !== false ? 'active' : 'collapsed' ?>" href="<?= base_url('subscriptions') ?>">
                <i class="bi bi-circle"></i>
                <span>Subscriptions</span>
              </a>
            </li>
            <!-- End super admin Page Nav -->

            <li class="nav-item">
              <a class="nav-link <?= strpos(uri_string(), 'settings') !== false ? 'active' : 'collapsed' ?>" href="<?= base_url('settings') ?>">
                <i class="bi bi-circle"></i>
                <span>Settings</span>
              </a>
            </li><!-- End settings Page Nav -->
          <?php endif; ?>
        </ul>
      </li><!-- End customization Nav -->
    <?php endif; ?>

    <!-- logout -->
    <li class="nav-item">
      <form action="<?= base_url('logout') ?>" method="post" x-data="formSubmit" @submit.prevent="submit">
        <?= csrf_field() ?>
        <button type="submit" class="btn btn-sm nav-link collapsed w-100" x-ref="btn">
          <i class="material-icons" style="font-size:24px;color:red">power_settings_new</i> <span>Logout</span>
        </button>
      </form>
    </li><!-- End logout Page Nav -->

  </ul>

</aside><!-- End Sidebar-->