<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1.0" name="viewport">

    <title>S-Tracker Contact</title>
    <meta name="description" content="S-Tracker is a web-based strategy tracking application designed to help organizations effectively manage and monitor their corporate strategies, initiatives, and key performance indicators (KPIs)">
    <meta content="Strategy, Performance, Management, Learning, Impact, Model" name="keywords">

    <!-- Favicons -->
    <link rel="shortcut icon" href="<?= base_url('favicon.png') ?>" type="image/png">
    <link href="<?= base_url('favicon.png') ?>" rel="apple-touch-icon">

    <meta property="og:url" content="<?= base_url('login') ?>">
    <meta property="og:type" content="Page" />
    <meta property="og:title" content="S-Tracker | Learning Impact Model">
    <meta property="og:description" content="S-Tracker is a web-based strategy tracking application designed to help organizations effectively manage and monitor their corporate strategies, initiatives, and key performance indicators (KPIs)">
    <meta property="og:image" content="<?= base_url('assets/img/lim.jpg') ?>">

    <!-- Fonts -->
    <link href="https://fonts.googleapis.com" rel="preconnect">
    <link href="https://fonts.gstatic.com" rel="preconnect" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&family=Ubuntu:ital,wght@0,300;0,400;0,500;0,700;1,300;1,400;1,500;1,700&family=Rubik:ital,wght@0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">

    <!-- Vendor CSS Files -->
    <link href="<?= base_url('assets2/vendor/bootstrap/css/bootstrap.min.css') ?>" rel="stylesheet">
    <link href="<?= base_url('assets2/vendor/bootstrap-icons/bootstrap-icons.css') ?>" rel="stylesheet">
    <link href="<?= base_url('assets2/vendor/aos/aos.css') ?>" rel="stylesheet">
    <link href="<?= base_url('assets2/vendor/glightbox/css/glightbox.min.css') ?>" rel="stylesheet">
    <link href="<?= base_url('assets2/vendor/swiper/swiper-bundle.min.css') ?>" rel="stylesheet">
    <!-- toastr alert -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" />
    <!-- apine js -->
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>

    <!-- Main CSS File -->
    <link href="<?= base_url('assets2/css/main.css') ?>" rel="stylesheet">
</head>

<body class="index-page">

    <header id="header" class="header d-flex align-items-center fixed-top">
        <div class="container position-relative d-flex align-items-center justify-content-between">

            <a href="<?= base_url('/') ?>" class="logo d-flex align-items-center me-auto me-xl-0">
                <!-- Uncomment the line below if you also wish to use an image logo -->
                <img src="<?= session()->has('logo') ? base_url(session()->get('logo')) : base_url('assets/favicon.png') ?>" alt="S-Tracker">
                <!-- <h1 class="sitename">S-Tracker</h1> -->
            </a>

            <nav id="navmenu" class="navmenu">
                <ul>
                    <li><a href="<?= base_url('/') ?>" class="active">Home</a></li>
                    <li><a href="#contact">Contact</a></li>
                    <li><a href="<?= base_url('privacy-policy') ?>">Privacy Policy</a></li>
                </ul>
                <i class="mobile-nav-toggle d-xl-none bi bi-list"></i>
            </nav>

            <a class="btn-getstarted" href="<?= base_url('login') ?>">Login</a>

        </div>
    </header>

    <main class="main">

<!-- Hero Section -->
    <section id="hero" class="hero section">
      <!-- Section Title -->
      <div class="container section-title" data-aos="fade-up">
        <span class="description-title">Contact Us</span>
        <h2>Contact Us</h2>
        <p>Complete the form below and we will get in touch.</p>
      </div><!-- End Section Title -->

      <div class="container" data-aos="fade-up" data-aos-delay="100">

        <div class="row justify-content-center align-items-center">

          <div class="col-lg-8">
            <?php if (isset($_GET['status']) && $_GET['status'] === 'success'): ?>
              <div class="alert alert-success alert-dismissible fade show" role="alert">
                Your message has been sent successfully!
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
              </div>
            <?php endif; ?>
          </div>

          <div class="col-lg-9">
            <div class="contact-form card" data-aos="fade-up" data-aos-delay="300">
              <div class="card-body p-4 p-lg-5">

                <form action="<?= base_url('contact') ?>" method="post" data-aos="fade-up" data-aos-delay="600">
                    <?= csrf_field() ?>

                  <div class="row gy-4">

                    <div class="col-12">
                      <input type="text" name="name" class="form-control" placeholder="Your Name" value="<?= set_value('name') ?>">
                      <p class="text-danger"><?= isset($validation) ? $validation->showError('name') : '' ?></p>
                    </div>

                    <div class="col-6 ">
                      <input type="email" class="form-control" name="email" placeholder="Your Email" value="<?= set_value('email') ?>">
                      <p class="text-danger"><?= isset($validation) ? $validation->showError('email') : '' ?></p>
                    </div>

                    <div class="col-6">
                      <input type="text" class="form-control" name="whatsapp_no" placeholder="WhatsApp No" value="<?= set_value('whatsapp_no') ?>">
                      <p class="text-danger"><?= isset($validation) ? $validation->showError('whatsapp_no') : '' ?></p>
                    </div>

                    <div class="col-6">
                      <input type="text" class="form-control" name="name_of_org" placeholder="Name of Organziation" value="<?= set_value('name_of_org') ?>">
                      <p class="text-danger"><?= isset($validation) ? $validation->showError('name_of_org') : '' ?></p>
                    </div>

                    <div class="col-6">
                      <input type="text" class="form-control" name="role_in_org" placeholder="Role in Organization" value="<?= set_value('role_in_org') ?>">
                      <p class="text-danger"><?= isset($validation) ? $validation->showError('role_in_org') : '' ?></p>
                    </div>

                    <div class="col-12">
                      <input type="text" class="form-control" name="subject" placeholder="Subject" value="<?= set_value('subject') ?>">
                      <p class="text-danger"><?= isset($validation) ? $validation->showError('subject') : '' ?></p>
                    </div>

                    <div class="col-12">
                      <textarea class="form-control" name="message" rows="6" placeholder="Message"><?= set_value('message') ?></textarea>
                      <p class="text-danger"><?= isset($validation) ? $validation->showError('message') : '' ?></p>
                    </div>

                    <div class="col-12 text-center">
                      <button type="submit" class="btn btn-submit btn-success w-100">Book Demo</button>
                    </div>

                  </div>
                </form>

              </div>
            </div>
          </div>


        </div>

      </div>
        
        
        <!-- Contact Section -->
        <section id="contact" class="contact section light-background">

            <!-- Section Title -->
            <div class="container section-title" data-aos="fade-up">
                <span class="description-title">Contact</span>
                <h2>Get in Touch</h2>
                <p>We’d love to hear from you. Whether you’re exploring S-Tracker for your organization, need product support, or want to partner with us — our team is ready to help.</p>
            </div><!-- End Section Title -->

            <div class="container" data-aos="fade-up" data-aos-delay="100">

                <div class="row g-5">
                    <div class="col-lg-6">
                        <div class="content" data-aos="fade-up" data-aos-delay="200">
                            <div class="section-category mb-3">Contact Us</div>
                            <h2 class="display-5 mb-4">Let’s Start the Conversation</h2>
                            <p class="lead mb-4">Reach out for inquiries, demo requests, or support. We’ll get back to you as quickly as possible.</p>

                            <div class="contact-info mt-5">
                                <div class="info-item d-flex mb-3" data-aos="fade-up" data-aos-delay="300">
                                    <i class="bi bi-envelope-at me-3"></i>
                                    <span>info@learningimpactmodel.com</span>
                                </div>

                                <div class="info-item d-flex mb-3" data-aos="fade-up" data-aos-delay="400">
                                    <i class="bi bi-telephone me-3"></i>
                                    <span>+234 818 195 6161</span>
                                </div>

                                <div class="info-item d-flex mb-4">
                                    <i class="bi bi-geo-alt me-3"></i>
                                    <span>Suite 3F4, Katu Koma Plaza, 52 Off Oladipo Diya Way, Sector Centre C, Abuja, FCT, Nigeria</span>
                                </div>
                                <div class="info-item d-flex mb-4">
                                    
                    <a class="btn btn-success" href="<?= base_url("contact") ?>">Contact Us</a>
                                </div>
                            </div>
                        </div>
                    </div>

                   <div class="col-lg-6">
            <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3940.5819852847226!2d7.457690473143711!3d9.010555389281235!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x104e0d9d3cd6095b%3A0xe5b9b289c3c890e7!2sKatu%20Koma%20Plaza!5e0!3m2!1sen!2sng!4v1758555905965!5m2!1sen!2sng" width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
          </div>

                </div>

            </div>

        </section><!-- /Contact Section -->

    </main>

    <footer id="footer" class="footer position-relative dark-background">

        <div class="container footer-top">
            <div class="row gy-4">
                <div class="col-lg-5 col-md-12 footer-about">
                    <a href="<?= base_url('/') ?>" class="logo d-flex align-items-center">
                        <span class="sitename">S-Tracker</span>
                    </a>
                    <p>
                        S-Tracker helps organizations design, track, and achieve their strategic goals.
                        Built on the Balanced Scorecard framework, it empowers leaders to align initiatives,
                        assign ownership, and monitor execution with clarity and accountability.
                    </p>
                    <div class="social-links d-flex mt-4">
                        <!-- <a href=""><i class="bi bi-twitter-x"></i></a> -->
                        <a href="https://www.facebook.com/profile.php?id=100093117607351" target="_blank"><i class="bi bi-facebook"></i></a>
                        <a href="https://www.instagram.com/learningimpactmodel/?hl=en" target="_blank"><i class="bi bi-instagram"></i></a>
                        <a href="https://www.linkedin.com/company/bebetterlearningimpactng/" target="_blank"><i class="bi bi-linkedin"></i></a>
                    </div>
                </div>


                <div class="col-lg-2 col-6 footer-links">
                    <h4>Useful Links</h4>
                    <ul>
                        <li><a href="<?= base_url('/') ?>">Home</a></li>
                        <li><a href="#about">About us</a></li>
                        <li><a href="#features">Why Strategy Fails</a></li>
                        <!--<li><a href="#services">Services</a></li>-->
                        <li><a href="#pricing">Pricing</a></li>
                        <li><a href="#faq">FAQs</a></li>
                        <li><a href="<?= base_url('privacy-policy') ?>">Privacy Policy</a></li>
                    </ul>
                </div>

                <div class="col-lg-2 col-6 footer-links">
                    <h4>Other Products</h4>
                    <ul>
                        <li><a href="https://onlineefiko.com" target="_blank">Online Efiko</a></li>
                        <li><a href="https://lifeskillsafrica.com" target="_blank">Life Skills Africa</a></li>
                        <li><a href="https://360feedback.com.ng" target="_blank">360 Feedback Solutions</a></li>
                        <li><a href="https://epapervendor.com" target="_blank">Epaper Vendor</a></li>
                        <li><a href="https://ldplanner.efikohr.com/" target="_blank">L&D Planner</a></li>
                        <li><a href="https://prater.efikohr.com/" target="_blank">P-Rater</a></li>
                    </ul>
                </div>

                <div class="col-lg-3 col-md-12 footer-contact text-center text-md-start">
                    <h4>Contact Us</h4>
                    <p>Suite 3F4, Katu Koma Plaza, </p>
                    <p>52 Off Oladipo Diya Way,</p>
                    <p>Sector Centre C, Abuja, FCT, Nigeria.</p>
                    <p class="mt-4"><strong>Phone:</strong> <span>+234 818 195 6161</span></p>
                    <p><strong>Email:</strong> <span>info@learninigimpactmodel.com</span></p>
                </div>

            </div>
        </div>
        <div class="container copyright text-center mt-4">
            <p>
                © <span id="year"></span> <span>Copyright</span>
                <strong class="px-1 sitename">S-Tracker</strong>
                <span>All Rights Reserved</span>
            </p>
            <div class="credits">
                Designed by <a href="https://learningimpactmodel.com/" target="_blank">Learning Impact Model</a>
            </div>
        </div>

        <script>
            document.getElementById("year").textContent = new Date().getFullYear();
        </script>


    </footer>

    <!-- Scroll Top -->
    <a href="#" id="scroll-top" class="scroll-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

    <!-- Vendor JS Files -->
    <script src="<?= base_url('assets2/vendor/bootstrap/js/bootstrap.bundle.min.js') ?>"></script>
    <script src="<?= base_url('assets2/vendor/php-email-form/validate.js') ?>"></script>
    <script src="<?= base_url('assets2/vendor/aos/aos.js') ?>"></script>
    <script src="<?= base_url('assets2/vendor/glightbox/js/glightbox.min.js') ?>"></script>
    <script src="<?= base_url('assets2/vendor/swiper/swiper-bundle.min.js') ?>"></script>
    <script src="<?= base_url('assets2/vendor/purecounter/purecounter_vanilla.js') ?>"></script>
    <!-- toastr alert -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <!-- apine js -->
    <script src="<?= base_url('assets/js/apine.js') ?>"></script>

    <!-- Main JS File -->
    <script src="<?= base_url('assets2/js/main.js') ?>"></script>
    <?= $this->include('components/alert') ?>

</body>

</html>