<?= $this->extend('components/html_boiler.php') ?>

<?= $this->section('content') ?>
<?= $this->include('components/navbar') ?>
<?= $this->include('components/sidebar') ?>

<main id="main" class="main">
    
<div class="pagetitle">
    <?php if (!empty($organization)): ?>
        <h1><?= esc($organization['name']) ?></h1>
        <nav>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?= base_url('home') ?>">Home</a></li>
                <li class="breadcrumb-item active">Organization</li>
            </ol>
        </nav>
        <?php endif; ?>
    </div><!-- End Page Title -->
    
    <!-- loop out the organization details if updated -->
    <?php if (!empty($organization)): ?>
        <!-- Organization details Card -->
        <div class="col-lg-9">
            <div class="card info-card sales-card">

                <div class="card-body">
                    <h5 class="card-title">Organization Details</h5>
                    <?php if($organization['logo'] !== null) : ?>
                        <img src="<?= base_url($organization['logo']) ?>" alt="<?= $organization['name'] ?>" style="max-width: 200px; height: auto;">
                    <?php endif; ?>
                    <h4><a href="<?= base_url('home') ?>" class="large-text mt-3"><?= $organization['name'] ?></a></h4>
                    <p class="card-text"><strong>API Key:</strong> <?= $organization['slug'] ?></p>
                </div>

            </div>
        </div><!-- End Organization details Card -->


        <?php if (in_array(session()->get('role'), ['admin', 'superadmin'])): ?>
            <section class="section mt-4">
                <div class="row">
                    <div class="col-lg-9">

                        <div class="card">
                            <div class="card-body">
                                <h5 class="card-title">Update Organization Details</h5>

                                <!-- Horizontal Form -->
                                <form action="<?= base_url('organization/update/' . $organization['slug']) ?>" method="post" x-data="formSubmit" @submit.prevent="submit" enctype="multipart/form-data">
                                    <?= csrf_field() ?>
                                    <input type="hidden" name="_method" value="PUT">
                                    <input type="hidden" name="id" value="<?= $organization['id'] ?>">

                                    <div class="row mb-3">
                                        <label for="name" class="col-sm-2 col-form-label">Name</label>
                                        <div class="col-sm-10">
                                            <input type="text" class="form-input" id="name" name="name" value="<?= $organization['name'] ?>">
                                            <p class="text-danger"><?= isset($validation) ? $validation->showError('name') : '' ?></p>
                                        </div>
                                    </div>
                                    <div class="row mb-3">
                                        <label for="inputEmail3" class="col-sm-2 col-form-label">Email</label>
                                        <div class="col-sm-10">
                                            <input type="email" class="form-input" id="email" name="email" value="<?= $organization['email'] ?>">
                                            <p class="text-danger"><?= isset($validation) ? $validation->showError('email') : '' ?></p>
                                        </div>
                                    </div>
                                    <div class="row mb-3">
                                        <label for="logo" class="col-sm-2 col-form-label">Logo</label>
                                        <div class="col-sm-10">
                                            <input type="file" class="form-input" id="logo" name="logo">
                                            <p class="text-danger"><?= isset($validation) ? $validation->showError('logo') : '' ?></p>
                                        </div>
                                    </div>
                                        <div class="row mb-3">
                                        <label for="logo" class="col-sm-3 col-form-label">Refresh API Key</label>
                                        <div class="col-2">
                                            <input type="checkbox" class="form-check" id="api_key" name="api_key">
                                        </div>
                                    </div>
                                    <div class="text-center">
                                        <button type="submit" class="btn btn-pink w-100" x-ref="btn">Update</button>
                                    </div>
                                </form><!-- End Horizontal Form -->

                            </div>
                        </div>
                    </div>
                </div>
            </section>
        <?php endif; ?>
    <?php endif; ?>
</main>
<?= $this->endSection() ?>