<?= $this->extend('components/html_boiler.php') ?>

<?= $this->section('content') ?>
<?= $this->include('components/navbar') ?>
<?= $this->include('components/sidebar') ?>

<main id="main" class="main">

    <div class="pagetitle">
        <h1>STracker</h1>
    </div><!-- End Page Title -->


    <?php if (in_array(session()->get('role'), ['superadmin'])): ?>
        <section class="section mt-4">
            <div class="row">
                <div class="col-lg-8">

                    <div class="card">
                        <div class="card-body">
                            <!-- display create form if lim address and logo is not set before -->
                            <?php if (empty($stracker)) : ?>
                                <h5 class="card-title">STracker Details</h5>

                                <!-- stracker settings Form -->
                                <form action="<?= base_url('settings') ?>" method="post" x-data="formSubmit" @submit.prevent="submit" enctype="multipart/form-data">
                                    <?= csrf_field() ?>

                                    <div class="row mb-3">
                                        <label for="lim_address" class="col-sm-2 col-form-label">LIM Address</label>
                                        <div class="col-sm-10">
                                            <input type="text" class="form-input" id="lim_address" name="lim_address" value="<?= '' ?>">
                                            <p class="text-danger"><?= isset($validation) ? $validation->showError('name') : '' ?></p>
                                        </div>
                                    </div>

                                    <div class="row mb-3">
                                        <label for="logo" class="col-sm-2 col-form-label">STracker Logo</label>
                                        <div class="col-sm-10">
                                            <input type="file" class="form-input" id="logo" name="logo">
                                            <p class="text-danger"><?= isset($validation) ? $validation->showError('logo') : '' ?></p>
                                        </div>
                                    </div>
                                    <div class="text-center">
                                        <button type="submit" class="btn btn-pink w-100" x-ref="btn">Save</button>
                                    </div>
                                </form><!-- End stracker settings Form -->
                            <?php else: ?>
                                <!-- display form to update settings -->
                                <h5 class="card-title">Update STracker Details</h5>

                                <!-- stracker settings Form -->
                                <form action="<?= base_url('settings/update') ?>" method="post" x-data="formSubmit" @submit.prevent="submit" enctype="multipart/form-data">
                                    <?= csrf_field() ?>
                                    <input type="hidden" name="_method" value="PUT">

                                    <div class="row mb-3">
                                        <label for="lim_address" class="col-sm-2 col-form-label">LIM Address</label>
                                        <div class="col-sm-10">
                                            <input type="text" class="form-input" id="lim_address" name="lim_address" value="<?= $stracker['lim_address'] ?>">
                                            <p class="text-danger"><?= isset($validation) ? $validation->showError('name') : '' ?></p>
                                        </div>
                                    </div>

                                    <div class="row mb-3">
                                        <label for="logo" class="col-sm-2 col-form-label">STracker Logo</label>
                                        <div class="col-sm-10">
                                            <input type="file" class="form-input" id="logo" name="logo">
                                            <p class="text-danger"><?= isset($validation) ? $validation->showError('logo') : '' ?></p>
                                        </div>
                                    </div>
                                    <div class="text-center">
                                        <button type="submit" class="btn btn-pink w-100" x-ref="btn">Update</button>
                                    </div>
                                </form>
                            <?php endif; ?>

                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php endif; ?>
</main>
<?= $this->endSection() ?>