<?= $this->extend('components/html_boiler.php') ?>

<?= $this->section('content') ?>
<?= $this->include('components/navbar') ?>
<?= $this->include('components/sidebar') ?>

<main id="main" class="main">
    <div class="text-end">
        <a href="<?= base_url('download/strategy-map') ?>" class="btn btn-sm" target="_blank">Export Strategy Map</a>
    </div>
    <h3 class="text-center mt-4 large-text">Our Strategy Map </h3>
    <?php
    // Build matrix: goals[pid][tid] = [goal1, goal2...]
    $goalMap = [];
    foreach ($strategyMatrix as $goal) {
        $pid = $goal['bscperspective_id'];
        $tid = $goal['theme_id'];
        $goalMap[$pid][$tid][] = $goal['description'];
    }
    ?>
    <div class="table-responsive">
        <table class="table table-bordered table-hover">
            <thead>
                <tr>
                    <th class="text-bg-secondary"></th>
                    <?php foreach ($themes as $theme): ?>
                        <th class="text-bg-secondary"><?= ucfirst(esc($theme['title'])) ?></th>
                    <?php endforeach; ?>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($perspectives as $persp): ?>
                    <tr>
                        <td class="text-bg-secondary"><strong><?= ucfirst(esc($persp['name'])) ?></strong></td>
                        <?php foreach ($themes as $theme): ?>
                            <td>
                                <?php
                                $goals = $goalMap[$persp['id']][$theme['id']] ?? [];
                                if ($goals): ?>
                                    <ul>
                                        <?php foreach ($goals as $goal): ?>
                                            <li><?= html_entity_decode($goal) ?></li>
                                        <?php endforeach; ?>
                                    </ul>
                                <?php else: ?>
                                    &mdash;
                                <?php endif; ?>
                            </td>
                        <?php endforeach; ?>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</main>
<?= $this->endSection() ?>