<?= $this->extend('components/html_boiler.php') ?>

<?= $this->section('content') ?>
<?= $this->include('components/navbar') ?>
<?= $this->include('components/sidebar') ?>

<main id="main" class="main">
    <?php if (!empty($themes)) : ?>
        <div class="text-end">
            <a href="<?= base_url('download/themes') ?>" class="btn btn-sm" target="_blank">Export Themes</a>
        </div>
        <h4 class="text-center large-text my-4">Our Strategic Themes</h4>
        <table class="table table-hover table-bordered">
            <thead>
                <tr>
                    <th scope="col" class="text-bg-secondary">Theme</th>
                    <th scope="col" class="text-bg-secondary">Description</th>
                    <th scope="col" class="text-bg-secondary"></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($themes as $theme) : ?>
                    <tr>
                        <td><?= esc($theme['title']) ?></td>
                        <td><?= esc($theme['description']) ?? '' ?></td>
                        <td><a href="<?= base_url('theme/view/' . $theme['slug']) ?>" class="btn btn-sm btn-secondary">See more...</a></td>
                    </tr>
                <?php endforeach; ?>

            </tbody>
        </table>
    <?php endif; ?>
</main>
<?= $this->endSection() ?>