<?= $this->extend('components/downloads_header.php') ?>

<?= $this->section('downloadContent') ?>

<div style="display:flex; justify-content:center; margin-top:15px; ">
    <a href="<?= base_url('home') ?>" style="text-decoration:none">Back to Dashboard</a>
    <button id="saveAsPdf" style="margin: auto 5px">Export as PDF</button>
    <button id="exportExcel">Export to Excel</button>
</div>

<script>
    document.getElementById("saveAsPdf").addEventListener("click", function() {
        document.getElementById('filter').style.display = 'none';
        const element = document.getElementById("pdfContent");

        const opt = {
            margin: 0.3, // smaller margins
            filename: '<?= ucwords(esc($organization['name'])) ?> initiatives.pdf',
            image: {
                type: 'jpeg',
                quality: 0.98
            },
            html2canvas: {
                scale: 3,
                useCORS: true
            }, // better quality
            jsPDF: {
                unit: 'in',
                format: 'a4',
                orientation: 'landscape'
            }
        };

        html2pdf().set(opt).from(element).save();
    });
</script>
<script>
    document.getElementById('exportExcel').addEventListener('click', function() {
        // Get the table element
        var table = document.getElementById('themesTable');

        // Convert table to a worksheet
        var workbook = XLSX.utils.table_to_book(table, {
            sheet: "<?= ucwords(esc($organization['name'])) ?> initiatives"
        });

        // Export the workbook
        XLSX.writeFile(workbook, '<?= ucwords(esc($organization['name'])) ?> initiatives.xlsx');
    });
</script>

<div id="pdfContent">

    <?php if (!empty($organization['logo'])): ?>
        <img
            src="<?= base_url($organization['logo']) ?>"
            alt="<?= esc($organization['name']) ?>"
            style="width:250px; display:block; margin: 30px auto 0 auto;" />
    <?php endif; ?>


    <h2 style="text-align:center;" class="large-text"><?= esc($organization['name']) ?> Initiatives</h2>
    <p style="text-align:center;">Exported at: <?= (new DateTime())->format('h:i A d M Y') ?></p>

    <div class="filter text-end me-5">
        <a class="icon" href="#" id="filter" data-bs-toggle="dropdown">Filter by</a>
        <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow">
            <li class="dropdown-header text-start">
                <h6>Status</h6>
            </li>

            <li><a class="dropdown-item data-filter" href="<?= base_url('initiatives?status=completed&action=download') ?>">Completed</a></li>
            <li><a class="dropdown-item data-filter" href="<?= base_url('initiatives?status=active&action=download') ?>">Active</a></li>
            <li><a class="dropdown-item data-filter" href="<?= base_url('initiatives?status=inactive&action=download') ?>">Inactive</a></li>
                                <li><a class="dropdown-item" href="<?= base_url('initiatives?status=due&action=download') ?>" data-status="inactive">Behind Schedule</a></li>
            <li><a class="dropdown-item data-filter" href="<?= base_url('initiatives?action=download') ?>">Show All</a></li>

        </ul>
    </div>

    <?php if (!empty($initiatives)) : ?>
        <table class="table datatable table-hover">
            <thead>
                <tr>
                    <th scope="col" class="text-bg-secondary">Initiatives</th>
                    <th scope="col" class="text-bg-secondary">Target</th>
                    <th scope="col" class="text-bg-secondary">Started</th>
                    <th scope="col" class="text-bg-secondary">Due date</th>
                    <th scope="col" class="text-bg-secondary">RAG Status</th>
                    <th scope="col" class="text-bg-secondary">Measure of success</th>
                    <th scope="col" class="text-bg-secondary">Status</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($initiatives as $initiative) : ?>
                    
                    <?php
                    // set appropriate rag_status

                    $color = '';

                    $endDate = new DateTime($initiative['end_date']);
                    $now = new DateTime();

                    if ($endDate < $now) {
                        $color = 'background-color:red';
                    } elseif ($initiative['rag_status'] === 'amber') {
                        $color = 'background-color:yellow';
                    } elseif ($endDate > $now && $initiative['status'] === 'active') {
                        $color = 'background-color:yellow';
                    } 
                    if ($initiative['status'] === 'completed') {
                        $color = 'background-color:green';
                    }
                    ?>

                    <tr>
                        <td><?= esc($initiative['name']) ?? '' ?></td>
                        <td><?= esc($initiative['target']) ?? '' ?></td>
                        <td><?= (new DateTime($initiative['start_date']))->format('d F, Y') ?></td>
                        <td><?= (new DateTime($initiative['end_date']))->format('d F, Y') ?></td>
                        <td style="<?= $color ?>"></td>
                        <td><?= ucfirst(esc($initiative['measure_of_success'])) ?? '' ?></td>
                        <td>
                            <?= isset($initiative['status']) ? ucwords(str_replace('_', ' ', $initiative['status'])) : '' ?>
                        </td>

                    </tr>
                <?php endforeach; ?>

            </tbody>
        </table>
    <?php else: ?>
        <div class="alert alert-info">No initiatives found</div>
    <?php endif; ?>
</div>

<?= $this->endSection() ?>