<?= $this->extend('components/downloads_header.php') ?>

<?= $this->section('downloadContent') ?>

<div style="display:flex; justify-content:center; margin-top:15px; ">
    <a href="<?= base_url('home') ?>" style="text-decoration:none">Back to Dashboard</a>
    <button id="saveAsPdf" style="margin: auto 5px">Export as PDF</button>
    <button id="exportExcel">Export to Excel</button>
</div>

<script>
    document.getElementById("saveAsPdf").addEventListener("click", function() {
        document.getElementById('filter').style.display = 'none';
        const element = document.getElementById("pdfContent");

        const opt = {
            margin: 0.3, // smaller margins
            filename: '<?= ucwords(esc($organization['name'])) ?> strategic-goals.pdf',
            image: {
                type: 'jpeg',
                quality: 0.98
            },
            html2canvas: {
                scale: 3,
                useCORS: true
            }, // better quality
            jsPDF: {
                unit: 'in',
                format: 'a4',
                orientation: 'portrait'
            }
        };

        html2pdf().set(opt).from(element).save();
    });
</script>
<script>
    document.getElementById('exportExcel').addEventListener('click', function() {
        // Get the table element
        var table = document.getElementById('themesTable');

        // Convert table to a worksheet
        var workbook = XLSX.utils.table_to_book(table, {
            sheet: "Strategic Goals"
        });

        // Export the workbook
        XLSX.writeFile(workbook, '<?= ucwords(esc($organization['name'])) ?> strategic_goals.xlsx');
    });
</script>



<div id="pdfContent">

    <?php if (!empty($organization['logo'])): ?>
        <img
            src="<?= base_url($organization['logo']) ?>"
            alt="<?= esc($organization['name']) ?>"
            style="width:250px; display:block; margin: 30px auto 0 auto;" />
    <?php endif; ?>


    <h2 style="text-align:center;" class="large-text"><?= ucwords(esc($organization['name'])) ?> High Level Goals </h2>
    <div class="filter text-end me-5">
        <a class="icon" href="#" id="filter" data-bs-toggle="dropdown">Filter by</a>
        <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow">
            <li class="dropdown-header text-start">
                <h6>Status</h6>
            </li>

            <li><a class="dropdown-item" href="<?= base_url('goals?status=completed&action=download') ?>">Completed</a></li>
            <li><a class="dropdown-item" href="<?= base_url('goals?status=active&action=download') ?>">Active</a></li>
            <li><a class="dropdown-item" href="<?= base_url('goals?status=inactive&action=download') ?>">Inactive</a></li>
            <li><a class="dropdown-item" href="<?= base_url('goals?action=download') ?>">Show All</a></li>

        </ul>
    </div>

    <?php if (!empty($goals)) : ?>
        <table id="themesTable" class="table datatable">
            <thead>
                <tr>
                    <th scope="col" class="text-bg-secondary">Strategy Framework Perspective</th>
                    <th scope="col" class="text-bg-secondary">Theme</th>
                    <th scope="col" class="text-bg-secondary">Goal</th>
                    <th scope="col" class="text-bg-secondary">Status</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($goals as $goal) : ?>
                    <tr>
                        <td><?= esc($goal['bscbscperspective_name']) ?></td>
                        <td><?= esc($goal['theme_name']) ?></td>
                        <td><?= esc($goal['description']) ?></td>
                        <td><?= esc($goal['status']) ?? '' ?></td>
                    </tr>
                <?php endforeach; ?>

            </tbody>
        </table>
    <?php endif; ?>
</div>

<?= $this->endSection() ?>