<?= $this->extend('components/downloads_header.php') ?>

<?= $this->section('downloadContent') ?>

<div style="display:flex; justify-content:center; margin-top:15px; ">
    <a href="<?= base_url('home') ?>" style="text-decoration:none">Back to Dashboard</a>
    <button id="saveAsPdf" style="margin: auto 5px">Export as PDF</button>
    <button id="exportExcel">Export to Excel</button>
</div>

<script>
    document.getElementById("saveAsPdf").addEventListener("click", function() {
        document.getElementById('filter').style.display = 'none';
        const element = document.getElementById("pdfContent");

        const opt = {
            margin: 0.3, // smaller margins
            filename: '<?= ucwords(esc($goal['description'])) ?> initiatives.pdf',
            image: {
                type: 'jpeg',
                quality: 0.98
            },
            html2canvas: {
                scale: 3,
                useCORS: true
            }, // better quality
            jsPDF: {
                unit: 'in',
                format: 'a4',
                orientation: 'landscape'
            }
        };

        html2pdf().set(opt).from(element).save();
    });
</script>
<script>
    document.getElementById('exportExcel').addEventListener('click', function() {
        // Get the table element
        var table = document.getElementById('themesTable');

        // Convert table to a worksheet
        var workbook = XLSX.utils.table_to_book(table, {
            sheet: "<?= ucwords(esc($goal['description'])) ?> initiatives"
        });

        // Export the workbook
        XLSX.writeFile(workbook, '<?= ucwords(esc($goal['description'])) ?> initiatives.xlsx');
    });
</script>

<div id="pdfContent">

    <?php if (!empty($organization['logo'])): ?>
        <img
            src="<?= base_url($organization['logo']) ?>"
            alt="<?= esc($organization['name']) ?>"
            style="width:250px; display:block; margin: 30px auto 0 auto;" />
    <?php endif; ?>


    <h2 style="text-align:center;" class="large-text">Goal: <?= ucwords(esc($goal['description'])) ?></h2>
    <p style="text-align:center;">Exported at: <?= (new DateTime())->format('h:i A d M Y') ?></p>

        <div class="filter text-end me-5">
        <a class="icon" href="#" id="filter" data-bs-toggle="dropdown">Filter by</a>
        <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow">
            <li class="dropdown-header text-start">
                <h6>Status</h6>
            </li>

            <li><a class="dropdown-item data-filter" href="#" data-status="completed">Completed</a></li>
            <li><a class="dropdown-item data-filter" href="#" data-status="active">Active</a></li>
            <li><a class="dropdown-item data-filter" href="#" data-status="inactive">Inactive</a></li>
            <li><a class="dropdown-item data-filter" href="#" data-status="all">Show All</a></li>

        </ul>
    </div>

    <?php if (!empty($initiatives)) : ?>
        <table id="themesTable">
            <thead>
                <tr>
                    <th scope="col">Initiatives</th>
                    <th scope="col">KPIs</th>
                    <th scope="col">Owners</th>
                    <th scope="col">Target</th>
                    <th scope="col">Started</th>
                    <th scope="col">Due date</th>
                    <th scope="col">RAG Status</th>
                    <th scope="col">Measure of success</th>
                    <th scope="col">Current Status</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($initiatives as $initiative) : ?>
                    <?php
                    // set appropriate rag_status

                    $color = '';

                    $endDate = new DateTime($initiative['end_date']);
                    $now = new DateTime();

                    if ($endDate < $now && $initiative['rag_status'] === 'amber') {
                        $color = 'background-color:red';
                    } elseif ($initiative['rag_status'] === 'amber') {
                        $color = 'background-color:yellow';
                    } else {
                        $color = "background-color:green";
                    }
                    ?>
                    <tr data-status="<?= esc(strtolower($initiative['status'])) ?>">
                        <td><?= esc($initiative['name']) ?? '' ?></td>
                        <td>
                            <?php if (!empty($initiative['kpis'])) : ?>
                                <ul class="mb-0 ps-3">
                                    <?php foreach ($initiative['kpis'] as $kpi) : ?>
                                        <li><?= esc(ucfirst($kpi)) ?></li>
                                    <?php endforeach; ?>
                                </ul>
                            <?php else : ?>
                                -
                            <?php endif; ?>
                        </td>
                        <td><?php if (!empty($initiative['owners'])) : ?>
                                <ul class="mb-0 ps-3">
                                    <?php foreach ($initiative['owners'] as $owner) : ?>
                                        <li><?= esc(ucfirst($owner['name'])) ?></li>
                                    <?php endforeach; ?>

                                </ul>
                            <?php else : ?>
                                -
                            <?php endif; ?>
                        </td>
                        <td><?= esc($initiative['target']) ?? '' ?></td>
                        <td><?= (new DateTime($initiative['start_date']))->format('d F, Y') ?></td>
                        <td><?= (new DateTime($initiative['end_date']))->format('d F, Y') ?></td>
                        <td style="<?= $color ?>"></td>
                        <td><?= ucfirst(esc($initiative['measure_of_success'])) ?? '' ?></td>
                        <td>
                            <?= isset($initiative['current_status']) ? ucwords(str_replace('_', ' ', $initiative['current_status'])) : '' ?>
                        </td>

                    </tr>
                <?php endforeach; ?>

            </tbody>
        </table>
    <?php endif; ?>
</div>

<script>
  document.querySelectorAll('.data-filter').forEach(item => {
    item.addEventListener('click', function (e) {
      e.preventDefault();
      const selected = this.getAttribute('data-status');

      document.querySelectorAll('table tbody tr').forEach(row => {
        const rowStatus = row.getAttribute('data-status');
        if (selected === 'all' || rowStatus === selected) {
          row.style.display = '';
        } else {
          row.style.display = 'none';
        }
      });
    });
  });
</script>

<?= $this->endSection() ?>